
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL]
GO
  
IF EXISTS ( SELECT * FROM SYS.OBJECTS
		WHERE NAME ='EST_PROD_TRANSF_NECESSIDADE')
BEGIN 
	DROP TABLE EST_PROD_TRANSF_NECESSIDADE
END

IF EXISTS ( SELECT * FROM SYS.OBJECTS
		WHERE NAME ='EST_PROD_TRANSF_AGENDAMENTO')
BEGIN 
	DROP TABLE EST_PROD_TRANSF_AGENDAMENTO
END

IF EXISTS ( SELECT * FROM SYS.OBJECTS
		WHERE NAME ='EST_PROD_TRANSF_NECESSIDADE_FUTURA')
BEGIN 
	DROP TABLE EST_PROD_TRANSF_NECESSIDADE_FUTURA
END
IF EXISTS ( SELECT * FROM SYS.OBJECTS
		WHERE NAME ='EST_PROD_TRANSF_MEDIAF_PARAMS')
BEGIN 
	DROP TABLE EST_PROD_TRANSF_MEDIAF_PARAMS
END 
IF EXISTS ( SELECT * FROM SYS.OBJECTS
		WHERE NAME ='EST_PROD_TRANSF_SOMA_POOL')
BEGIN 
	DROP TABLE EST_PROD_TRANSF_SOMA_POOL
END 
IF EXISTS ( SELECT * FROM SYS.OBJECTS
		WHERE NAME ='EST_PROD_TRANSF_PRODUTOS')
BEGIN 
	DROP TABLE EST_PROD_TRANSF_PRODUTOS
END
GO


SET ANSI_NULLS ON
GO 
SET QUOTED_IDENTIFIER ON
GO   


CREATE PROCEDURE [dbo].[P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL] 
								@CD_EMP				INT   = 1, 
								@CD_FILIAL			INT   = 0, 
								@CONSULTA			INT   = 0, 
								@PERC_FACE			MONEY = NULL, 
								@CD_PROD			INT   = NULL,
								@CD_CTR_DEPO		INT   = 1 , 
								@CD_CTR_DEPO_AUX	INT = NULL,
								@DIAS_ACRESCENTAR_RESSUP INT =0,
								@POOL_RESSUPRIMENTO		 TINYINT =0,
								@CD_AGENDA			INT =0

as	 
/*
=======================================================================================
'Job.................: Linx - Geracao ressuprimento depositos (Executada pela P_GERA_RESSUPRIMENTO_DEPOSITO )
'Funo..............:  
'Objetivo............: Geracao ressuprimento depositos
'Tabelas.............: EST_PROD_TRANSF
'Dt Modificao......: 22/06/2021
'Modificao.........: Tag #A001 - Tratamento para considerar PERC_AUMENTO
					   Tag #I001 - Adicionado index 
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
*/
/* Par?metro de consulta:
	- 0: executa efetivamente o ressuprimento, sem mostrar resultados parciais
	- >0: apenas simula o ressuprimento; se produto selecionado, mostra resultados parciais segundo m?scara de bits:
		- bit0 - 1, 3, 5, ...: mostra resultados parciais em geral, 
		- bit1 - 2, 3, 6, 7, 10, ...: mostra a opera??o de arredondamento*/
		
SET NOCOUNT ON;
SET DEADLOCK_PRIORITY HIGH;
--SET ANSI_WARNINGS OFF; 
DECLARE	@mensagemErro	VARCHAR(255),
		@severidadeErro INT,
		@estadoErro		INT,
		@CD_DEPOSITO	INT,
		@AJUSTA_DEMANDA_EMB INT,
		@TP_PRECO			INT,
		@TP_PRECO_FILIAL	INT,
		@CD_DEPO_OPERADOR		INT,
		@RegistraFaltas			INT,
		@QT_DIVIDE_RESSUP		INT=0,
		@RESSUP_CAIXA_FECHADA	INT=0,
		@DEPO_AUX_DISTRIBUIDOR	INT=0,
		@UTILIZA_UN_RESSUP_DIST 	INT=0,
		@UTILIZA_AGENDA			INT=0,
		@DIAS_RES_ACRESCENTAR	INT=0, 
		@NAO_RESSUP_PROD_BLOQ_EMP		INT =0,
		@NAO_DIVIDE_RESSUP_CX_FECHADA	INT =0,
		@CD_GRP_ECON_DEPOSITO			INT=0, 
		@RealizaDescVendaGrpEcon		TINYINT =0,
		@UtilizarEsegDecimal			TINYINT =0,
		@CD_DEPOSITO_FALTA				INT =0,
		@AgdConsidEseg					TINYINT =0,
		@ParamAddAgd					money,
		@PERC_AUMENTO					MONEY =0.49,
		@FLAG_UTILIZA_ARREDONDAMENTO_RESSUP_DIRETO INT = 0;;
if @CD_PROD=0
	set @CD_PROD=null;
 	
INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
			,'Inicio dos registro de necessidade de ressuprimento '  
			,'INFORMACAO'
			,123
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			, NULL
			,'RESSUPRIMENTO')

/************************************************************************************************************/
SET @CD_DEPOSITO = (SELECT TOP 1 CD_FILIAL 
						FROM 
							PRC_FILIAL_DEPOSITO 
						WHERE 
							CD_EMP = @CD_EMP 
							AND CD_CTR_DEPO = @CD_CTR_DEPO);
IF @CD_CTR_DEPO_AUX > 0 
	BEGIN 
		SET @CD_DEPOSITO = (SELECT TOP 1 CD_FILIAL_DEPO_AUX
								FROM 
									PRC_FILIAL_DEPOSITO_AUXILIAR
								WHERE 
									CD_EMP = @CD_EMP 
									AND CD_CTR_DEPO = @CD_CTR_DEPO
									AND CD_CTR_DEPO_AUX = @CD_CTR_DEPO_AUX); 
		PRINT 'Ressuprimento para Deposito auxiliar Filial : ' + convert(varchar(5), @CD_DEPOSITO ) + ' - '  + CONVERT(VARCHAR, GETDATE(), 108)
		
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
					,'Ressuprimento para Deposito auxiliar Filial : ' + convert(varchar(5), @CD_DEPOSITO ) 
					,'INFORMACAO'
					,150
					,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
					, NULL
					,'RESSUPRIMENTO')
	END
else
	begin
		PRINT 'Ressuprimento para Deposito principal Filial : ' + convert(varchar(5), @CD_DEPOSITO ) + ' - ' + convert(varchar(5), @CD_CTR_DEPO ) + ' - '  + CONVERT(VARCHAR, GETDATE(), 108)
		
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
					,'Ressuprimento para Deposito principal Filial : ' + convert(varchar(5), @CD_DEPOSITO ) 
					,'INFORMACAO'
					,163
					,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
					, NULL
					,'RESSUPRIMENTO')
	end


	--Corrige informacao errada 
	UPDATE EST_PROD_PRT_GRP_RESSUPRIMENTO SET CD_CTR_DEPO= NULL WHERE CD_CTR_DEPO=0;
/****************************************************************************************************************************/
-- Carrega os parametros
/****************************************************************************************************************************/

INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
					,'Carrega os parametros de variaveis'
					,'INFORMACAO'
					,180
					,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
					, NULL
					,'RESSUPRIMENTO')

IF @DIAS_ACRESCENTAR_RESSUP =0
BEGIN
	SET @DIAS_RES_ACRESCENTAR=ISNULL((SELECT DIAS_RES_ACRESCENTAR FROM PRC_EMP WHERE CD_EMP = @CD_EMP),0);
END
ELSE
BEGIN
	SET @DIAS_RES_ACRESCENTAR=@DIAS_ACRESCENTAR_RESSUP
END
SET @PERC_FACE = ISNULL(@PERC_FACE,100)/100.000; 
SET @CD_DEPO_OPERADOR = (SELECT FLAG_OPERADOR_LOG FROM PRC_FILIAL WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_DEPOSITO)
SET @AJUSTA_DEMANDA_EMB = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'NAO_AJUSTAR_DEMANDA_PROD_CAIXA_FECHADA_RESSUP'),0);
-- Se for nulo pega 9 - Qualquer preco
SET @TP_PRECO = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'FLAG_TP_PRECO_CUSTO_RESSUP'),9);

-- Valida se foi definido tipo de preo a nivel de filial
SET @TP_PRECO_FILIAL = (SELECT VALOR FROM PRC_FILIAL_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'FLAG_TP_PRECO_CUSTO_RESSUP_FILIAL' AND CD_FILIAL = @CD_FILIAL);

-- Se existir parametrizao de tipo de preo para a filial, sobrepe a parametrizao para empresa
IF @TP_PRECO_FILIAL IS NOT NULL
BEGIN
	SET @TP_PRECO = CASE WHEN @TP_PRECO_FILIAL = 9 THEN @TP_PRECO ELSE @TP_PRECO_FILIAL END
END

SET @UTILIZA_AGENDA = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'UTILIZA_AGD_RESSUPRIMENTO'),0);
SET @NAO_DIVIDE_RESSUP_CX_FECHADA = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'NAO_DIVIDE_RESSUP_CX_FECHADA'),0);
SET @RealizaDescVendaGrpEcon =ISNULL((SELECT 
											CONCEDE_DESC_VENDA_GRP_ECON
										FROM 
											GLB_MOV_OP
										WHERE
											CD_MOV_OP= ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG 
																	WHERE CD_CHAVE LIKE 'CD_MOV_OP_VENDA_GRP_ECON'	
																			AND CD_FILIAL =@CD_DEPOSITO),0)),0);
SET @CD_GRP_ECON_DEPOSITO = ISNULL((SELECT CD_GRP_ECON	FROM PRC_GRP_ECON_PRC_FILIAL 
										WHERE CD_FILIAL =@CD_DEPOSITO
												AND CD_EMP=@CD_EMP),0);
if @UTILIZA_AGENDA =0
begin
	SET @UTILIZA_AGENDA = ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'UTILIZA_AGD_RESSUPRIMENTO'  AND CD_FILIAL=@CD_DEPOSITO),0);
end 
SET @NAO_RESSUP_PROD_BLOQ_EMP= ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG 
									WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'NAO_RESSUPRIR_PROD_BLOQ_EMPRESA'  AND CD_FILIAL=@CD_DEPOSITO),0);
SET @RegistraFaltas = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'REGISTRA_FALTAS_RESSUPRIMENTO'),0);
if @RegistraFaltas =0
	SET @RegistraFaltas = ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG 
										WHERE 
												CD_EMP = @CD_EMP 
												AND CD_CHAVE = 'REGISTRA_FALTAS_RESSUPRIMENTO'
												and  CD_FILIAL =@CD_DEPOSITO ),0);
SET @CD_DEPOSITO_FALTA =
ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG 
										WHERE 
												CD_EMP = @CD_EMP 
												AND CD_CHAVE = 'CD_FILIAL_DEPOSITO_PROCESSA_FALTAS'
												and  CD_FILIAL =@CD_DEPOSITO ),0);
SET @QT_DIVIDE_RESSUP = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'QTDE_ITENS_DIVIDE_RESSUPRIMENTO'),0);
SET @RESSUP_CAIXA_FECHADA = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'RESSUPRIMENTO_APENAS_CAIXA_FECHADA'),0);
--Diz se o deposito auxiliar  um distribuidor, neste caso o ressup vai ser transformado em ped. eltronico.
SET @DEPO_AUX_DISTRIBUIDOR	= ISNULL((SELECT VALOR FROM PRC_FILIAL_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'DEPOSITO_AUXILIAR_DISTRIBUIDOR' AND CD_FILIAL=@CD_DEPOSITO),0);
SET @UTILIZA_UN_RESSUP_DIST = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'UTILIZA_UN_RESSUP_DEPO_AUX_DIST'),0);
SET @UtilizarEsegDecimal	= ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'UTILIZA_ESEG_DECIMAL_RESSUPRIMENTO'),0);
SET @PERC_AUMENTO			= ISNULL((SELECT CASE WHEN ISNUMERIC(VALOR) = 1 THEN CONVERT(MONEY, VALOR) ELSE 0.49 END FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'PERC_AUMENTO_CAIXA_FECHADA_RESSUP'), 0.49);
SET @FLAG_UTILIZA_ARREDONDAMENTO_RESSUP_DIRETO	= ISNULL((SELECT CASE WHEN ISNUMERIC(VALOR) = 1 THEN CONVERT(INT, VALOR) ELSE 0 END FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'FLAG_UTILIZA_ARREDONDAMENTO_RESSUP_DIRETO'), 0);
--TRAVA DE SEGURANA CASO ALGUM USURIO COLOQUE UM VALOR DE PARMETRO INCORRETO
IF @PERC_AUMENTO <= 0 OR @PERC_AUMENTO > 1
BEGIN
	SET @PERC_AUMENTO = 0.49
END
/****************************************************************************************************************************/
PRINT 'Atualizacao cronograma de balanco'

INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
					,'Atualizacao cronograma de balanco'
					,'INFORMACAO'
					,250
					,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
					, 'P_GERA_EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_FILIAL_CRONOGRAMA'
					,'RESSUPRIMENTO')

	EXECUTE P_GERA_EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_FILIAL_CRONOGRAMA;
PRINT 'Fim da atualizacao cronograma de balanco'

/****************************************************************************************************************************/

BEGIN TRY  ------------------------------------------------------------------------------------------------------

	DECLARE	@HOJE				DATETIME,
			@DIA_SEMANA			INT;
	SELECT	@HOJE = CONVERT(CHAR(10),GETDATE() + @DIAS_RES_ACRESCENTAR,120),
			@DIA_SEMANA = DATEPART(weekday,@HOJE);
	Print '****** Geracao de ressuprimento para o dia ' + convert(varchar, @HOJE, 112) + ' ***********'
	Print '****** Filial Deposito ' + convert(varchar, @CD_DEPOSITO ) 
	Print '****** Cd ctr depo ' + convert(varchar, @CD_CTR_DEPO)
	Print '****** Cd ctr depo Aux ' + isnull(convert(varchar, @CD_CTR_DEPO_AUX),'Null')
	Print '***********************************************************************************'
/****************************************************************************************************************************/
	IF @CONSULTA=2
		SET @RegistraFaltas=0;
/****************************************************************************************************************************/
	IF @POOL_RESSUPRIMENTO = 0
	BEGIN
		IF EXISTS ( SELECT * FROM SYS.OBJECTS
				WHERE NAME ='EST_PROD_TRANSF_PRODUTOS')
		BEGIN 
			DROP TABLE EST_PROD_TRANSF_PRODUTOS
		END
		CREATE TABLE EST_PROD_TRANSF_PRODUTOS (CD_EMP INT,
												CD_PROD INT ,
												HABILITA INT,
												[QT_UNI_RESSUPRIMENTO] [money] NULL,
												[FLAG_RESSUPRIMENTO_CAIXA_FECHADA] [int] NULL,
												STS_PROD INT,
												CD_FABRIC INT,
												COMPRA_POR_SUPRIMENTO int
												PRIMARY KEY (CD_PROD,CD_EMP )) 
		INSERT INTO EST_PROD_TRANSF_PRODUTOS 
		SELECT DISTINCT 
			p.CD_EMP, 
			p.CD_PROD, 
			1 HABILITA, -- Inicialmente todos os produtos que tem no estoque do cd
			CASE
				WHEN @DEPO_AUX_DISTRIBUIDOR = 1
					AND @UTILIZA_UN_RESSUP_DIST = 0
				THEN 1
				ELSE CASE
						WHEN ISNULL(P.QT_UNI_RESSUPRIMENTO, 0) < 1
						THEN 1
						ELSE ISNULL(P.QT_UNI_RESSUPRIMENTO, 0)
					END
			END QT_UNI_RESSUPRIMENTO,
			CASE
				WHEN @DEPO_AUX_DISTRIBUIDOR = 1
					AND @UTILIZA_UN_RESSUP_DIST = 0
				THEN 0
				ELSE p.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
			END FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
			p.STS_PROD,
			p.CD_FABRIC,
			p.COMPRA_POR_SUPRIMENTO
		FROM EST_PROD P
			 JOIN V_EST_PROD_CPL_ESTOQUE e ON p.cd_emp = e.cd_emp
											  AND p.cd_prod = e.cd_prod
		WHERE e.CD_EMP = @CD_EMP
			  AND e.CD_FILIAL = @CD_DEPOSITO
			  AND e.STS_PROD <> 1
			  AND (@CD_PROD IS NULL OR e.CD_PROD = @CD_PROD)
			  AND (CASE WHEN @RegistraFaltas = 1 THEN 1
					   ELSE e.QT_EST END) > 0;

		CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_PRODUTOS_CD_EMP_HABILITA_FLAG_RESSUPRIMENTO_CAIXA_FECHADA_STS_PROD
		ON [dbo].[EST_PROD_TRANSF_PRODUTOS] ([CD_EMP],[HABILITA],[FLAG_RESSUPRIMENTO_CAIXA_FECHADA],[STS_PROD])
		INCLUDE ([QT_UNI_RESSUPRIMENTO],[CD_FABRIC],[COMPRA_POR_SUPRIMENTO])
		

		PRINT convert(varchar, @@ROWCOUNT) + ' Produtos  ' 

		PRINT 'Carregou a tabela de produtos que farao parte do ressuprimento - Time : ' + convert(varchar, getdate(), 108);
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
					,'Carregou a tabela de produtos que farao parte do ressuprimento '
					,'INFORMACAO'
					,306
					,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
					,'EST_PROD_TRANSF_PRODUTOS'
					,'RESSUPRIMENTO')
	END

/****************************************************************************************************************************/
--Cria tabelas auxiliares
/****************************************************************************************************************************/
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_MEDIAF_PARAMS')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_MEDIAF_PARAMS
	END
	CREATE TABLE [dbo].[EST_PROD_TRANSF_MEDIAF_PARAMS](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_GRP_RES] [int] NOT NULL,
		[CD_GRP_PARAM] [int] NULL,
		[CD_PROD] [int] NOT NULL,
		[EMAX] [money] NULL,
		[ESEG] [money] NULL,
		[PARAM_ESPECIAL] [int] NULL,
		[FDIAS] [int] NULL,
		[CD_SIGLA] [int] NULL,
		[QT_UNI_RESSUPRIMENTO] [money] NULL,
		[FLAG_RESSUPRIMENTO_CAIXA_FECHADA] [int] NULL,
		[ConsideraEseg] [tinyint] NULL,
		[TpGrupoParam] [tinyint] NULL,
		[Remover] [tinyint] NULL); 
	
/****************************************************************************************************************************/	
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_NECESSIDADE')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_NECESSIDADE
	END
	CREATE TABLE EST_PROD_TRANSF_NECESSIDADE  (CD_FILIAL				INT,
													CD_PROD					INT,
													EMAX					MONEY,
													QMIN					MONEY,
													QTDE_MEDIAF				MONEY,
													QT_EST_RESSUP_ORIG		MONEY,
													QT_EST_RESSUP			MONEY,
													VLR_PROD				MONEY,
													VLR_CUSTO_MD			MONEY,
													CD_GRP_RES				INT,
													QTDE_EST				MONEY,
													QT_EST_RESSUP_INI		MONEY,
													CD_SIGLA				INT,
													ESEGCAD					MONEY,
													EMAXCAD					MONEY,
													PARAM_ESPECIAL			INT,
													CD_GRP_PRT				INT,
													QT_UNI_RESSUPRIMENTO	INT,
													FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT,
													PERC_RATEIO				MONEY	DEFAULT(0),
													MEDIAF_SOMA				MONEY	DEFAULT(0),
													QTDE_DEPOS_SOMA			MONEY	DEFAULT(0),
													QTDE_FILIAIS_SOMA		MONEY	DEFAULT(0),
													FLAG_RATEIO				INT		DEFAULT(0),
													FLAG_AJUSTE_RATEIO		INT		DEFAULT(0),
													PERC_DESC				MONEY	DEFAULT(0),
													QT_EST_LJ				MONEY ,
													QT_PEND_ENT_LJ			MONEY ,													
													QT_EST_DEPO_RES			MONEY ,
													QT_FACEAMENTO			MONEY ,	
													QT_FINANCIAMENTO		MONEY ,
													QT_LIMITADOR			MONEY ,
													ALIQ_ICMS_ENTRADA		MONEY,
													QT_EST_RESSUP_PICKING	MONEY,
													VLR_CUSTO_PROD_ORIG		MONEY,
													PRIMARY KEY (CD_PROD, CD_FILIAL));
/****************************************************************************************************************************/							
	IF EXISTS ( SELECT * FROM SYS.OBJECTS
			WHERE NAME ='EST_PROD_TRANSF_NECESSIDADE_FUTURA')
	BEGIN 
		DROP TABLE EST_PROD_TRANSF_NECESSIDADE_FUTURA
	END
	CREATE TABLE EST_PROD_TRANSF_NECESSIDADE_FUTURA  (CD_FILIAL				INT,
													CD_PROD					INT,
													EMAX					MONEY,
													QMIN					MONEY,
													QTDE_MEDIAF				MONEY,
													QT_EST_RESSUP_ORIG		MONEY,
													QT_EST_RESSUP			MONEY,
													VLR_PROD				MONEY,
													VLR_CUSTO_MD			MONEY,
													CD_GRP_RES				INT,
													QTDE_EST				MONEY,
													QT_EST_RESSUP_INI		MONEY,
													CD_SIGLA				INT,
													ESEGCAD					MONEY,
													EMAXCAD					MONEY,
													PARAM_ESPECIAL			INT,
													CD_GRP_PRT				INT,
													QT_UNI_RESSUPRIMENTO	MONEY,
													FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT,
													PERC_RATEIO				MONEY	DEFAULT(0),
													MEDIAF_SOMA				MONEY	DEFAULT(0),
													QTDE_DEPOS_SOMA			MONEY	DEFAULT(0),
													QTDE_FILIAIS_SOMA		MONEY	DEFAULT(0),
													FLAG_RATEIO				INT		DEFAULT(0),
													FLAG_AJUSTE_RATEIO		INT		DEFAULT(0),
													PERC_DESC				MONEY	DEFAULT(0),
													QT_EST_LJ				MONEY ,
													QT_PEND_ENT_LJ			MONEY ,
													POSICAO					INT,
													SUB_TOTAL				MONEY,
													QT_EST_DEPO_RES			MONEY ,
													QT_FACEAMENTO			MONEY ,	
													QT_FINANCIAMENTO		MONEY ,
													QT_LIMITADOR			MONEY ,
													ConsideraEseg			tinyint,
													VLR_CUSTO_PROD_ORIG		MONEY,
													PRIMARY KEY (CD_PROD, CD_FILIAL));
/****************************************************************************************************************************/
		IF EXISTS ( SELECT * FROM SYS.OBJECTS
					WHERE NAME ='EST_PROD_TRANSF_PEDIDO')
			BEGIN 
				DROP TABLE EST_PROD_TRANSF_PEDIDO
			END		
		CREATE TABLE EST_PROD_TRANSF_PEDIDO ( CD_FILIAL			INT,
												CD_PROD				INT,
												QT_PED				MONEY,
												PERC_RATEIO			MONEY,
												MEDIAF_SOMA			MONEY,
												QTDE_DEPOS_SOMA		MONEY,
												QTDE_FILIAIS_SOMA	MONEY,
												PRIMARY KEY (CD_PROD, CD_FILIAL));
 /****************************************************************************************************************************/
		IF EXISTS ( SELECT * FROM SYS.OBJECTS
					WHERE NAME ='EST_PROD_TRANSF_AGENDAMENTO')
			BEGIN 
				DROP TABLE EST_PROD_TRANSF_AGENDAMENTO
			END		
		CREATE TABLE EST_PROD_TRANSF_AGENDAMENTO ( CD_EMP		INT,
														CD_FILIAL			INT,
														CD_PROD				INT,
														PARAM_ADICIONAL		 MONEY,
														FLAG_NAO_ENVIAR_PBM  INT, 
														DIARIO				 tinyint,
														PRIMARY KEY (CD_PROD, CD_FILIAL));
/****************************************************************************************************************************/
		 IF EXISTS ( SELECT * FROM SYS.OBJECTS
							WHERE NAME ='EST_PROD_TRANSF_CONSOLIDADO')
					BEGIN 
						DROP TABLE EST_PROD_TRANSF_CONSOLIDADO
					END	
		CREATE TABLE EST_PROD_TRANSF_CONSOLIDADO  (CD_PROD					INT,
														QT_EST_FILIAIS_SOMA		MONEY,
														QT_MEDIAF_SOMA			MONEY,
														QT_RESSUP_SOMA			MONEY,
														QT_NECESSIDADE_FILIAIS	MONEY,
														QT_DEPOSITO				MONEY,--aqui divide pela unidade de ressuprimento
														QT_DEPOSITO_INICIO		MONEY,--aqui nao divide
														QT_UNI_RESSUPRIMENTO	MONEY,
														FLAG_RESSUPRIMENTO_CAIXA_FECHADA INT,
														FLAG_RATEIO				INT DEFAULT 0, --houve rateio naquele produto com alguma filial?
														PERC_DESC				MONEY DEFAULT 0,
														PRIMARY KEY (CD_PROD));
/****************************************************************************************************************************/
		IF EXISTS ( SELECT * FROM SYS.OBJECTS
						WHERE NAME ='EST_PROD_TRANSF_SOMA_POOL')
				BEGIN 
					DROP TABLE EST_PROD_TRANSF_SOMA_POOL
				END	
		CREATE TABLE EST_PROD_TRANSF_SOMA_POOL  (CD_EMP		INT,
												CD_FILIAL			INT,
												CD_PROD				INT,
												SOMA_QT_SOL		 MONEY,
											PRIMARY KEY (CD_EMP, CD_PROD, CD_FILIAL));
/****************************************************************************************************************************/
		IF OBJECT_ID('TEMPDB..#ARREDONDA') IS NOT NULL 
			BEGIN
				DROP TABLE #ARREDONDA
			END
			CREATE TABLE #ARREDONDA( CD_EMP INT
									,CD_FILIAL	   INT
									,CD_CTR		   INT
									,CD_PROD	   INT
									,QT_SOL		   MONEY
									,QTDE_ARREDOND MONEY
									,QT_AJUSTADA	MONEY
									,CD_USU			INT
									,DT_CAD			DATETIME)

/****************************************************************************************************************************/
		CREATE TABLE #TMP_COMPRA_POR_SUPRIMENTO (ID TINYINT);
		if @DEPO_AUX_DISTRIBUIDOR= 1 --Se  um distribuidor, compra itens de ressuprimento.
		begin
			INSERT INTO #TMP_COMPRA_POR_SUPRIMENTO 
			SELECT 0 id
			union all SELECT 2 --Sup/Ressup
		end
		else
		begin
			INSERT INTO #TMP_COMPRA_POR_SUPRIMENTO 
			SELECT 1 ID 
			UNION ALL SELECT 2		
			UNION ALL SELECT 0			
		end
/****************************************************************************************************************************/
	PRINT 'Criou as tabelas auxiliares - Time : ' + convert(varchar, getdate(), 108);


	SELECT 
		A.CD_EMP,
		A.CD_PROD, 
		ISNULL(CASE WHEN C.PERC_AUMENTO > 0 THEN 
				C.PERC_AUMENTO 
			WHEN D.PERC_AUMENTO > 0 THEN
				D.PERC_AUMENTO 
			ELSE L.PERC_AUMENTO END,0) PERC_AUMENTO
	INTO
		#PARAM_CATEGORIA_LINHA_DEPTO
	FROM
		EST_PROD_EST_ARV_MERCADOLOGICA A
		INNER JOIN EST_ARV_MERC_CATEGORIA PC ON 
		A.CD_EMP			= PC.CD_EMP AND
		A.CD_ARV_MERC_CATEG = PC.CD_ARV_MERC_CATEG
		LEFT JOIN EST_PROD_TRANSF_PARAM_EST_ARV_MERC_LINHA L ON 
		A.CD_EMP			= L.CD_EMP AND
		A.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA 
		and l.DT_RESSUP= @HOJE
		and l.CD_FILIAL_DEPOSITO=@CD_DEPOSITO 
		LEFT JOIN EST_PROD_TRANSF_PARAM_EST_ARV_MERC_CATEGORIA C ON
		A.CD_EMP			= C.CD_EMP AND
		A.CD_ARV_MERC_CATEG = C.CD_ARV_MERC_CATEG
		and c.DT_RESSUP= @HOJE
		and c.CD_FILIAL_DEPOSITO=@CD_DEPOSITO
		LEFT JOIN EST_PROD_TRANSF_PARAM_EST_ARV_MERC_DEPTO D ON
		PC.CD_EMP			= D.CD_EMP AND
		PC.CD_ARV_MERC_DEPTO = D.CD_ARV_MERC_DEPTO
		and d.DT_RESSUP= @HOJE
		and d.CD_FILIAL_DEPOSITO=@CD_DEPOSITO

	CREATE INDEX IX_PARAM_CATEGORIA_LINHA_DEPTO_TMP ON #PARAM_CATEGORIA_LINHA_DEPTO (CD_EMP, CD_PROD) INCLUDE (PERC_AUMENTO)

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
					,' Criou as tabelas auxiliares'
					,'INFORMACAO'
					, 525 
					,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
					,'EST_PROD_TRANSF_ Etc..'
					,'RESSUPRIMENTO')

	DECLARE @CD_FIL_RES  AS INT
	if @cd_agenda > 0 
	begin
		DECLARE ljs CURSOR FAST_FORWARD FOR 		
		SELECT
			CD_FILIAL	 
		FROM  
			EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL
		WHERE
			CD_AGD_RESSUP = @cd_agenda
			AND (CD_FILIAL=@CD_FILIAL OR @CD_FILIAL=0 )
	end
	else
	begin
		DECLARE ljs CURSOR FAST_FORWARD FOR 
		SELECT
			CD_FILIAL 
		FROM PRC_FILIAL_DEPOSITO_PRC_FILIAL
		WHERE 
			CD_CTR_DEPO = @CD_CTR_DEPO
			--and cd_filial >999
			AND (CD_FILIAL=@CD_FILIAL OR @CD_FILIAL=0 )
	end
	OPEN ljs
	FETCH NEXT FROM ljs INTO @CD_FIL_RES
	WHILE @@FETCH_STATUS=0
		BEGIN
			
			INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
					,'Insere dados da filial ' + convert(varchar, @CD_FIL_RES)
					,'INSERT'
					, 569
					,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
					,'EST_PROD_TRANSF_MEDIAF_PARAMS'
					,'RESSUPRIMENTO')

			--Marca os produtos que podem ser atendidos por este CD para a filial @CD_FIL_RES
			--Se for um deposito auxiliar 
			-- Pega todos os produtos q o auxiliar trabalha
			if @CD_CTR_DEPO_AUX > 0 AND @DEPO_AUX_DISTRIBUIDOR =0
			begin
				-- Inicialmente os produtos nao participam
				update EST_PROD_TRANSF_PRODUTOS set HABILITA  = 0
				UPDATE P  SET  HABILITA  = 1 --Habilita apenas os produtos q o Aux. trabalha
				FROM 
					EST_PROD_TRANSF_PRODUTOS P
					INNER JOIN  ( SELECT 
									CD_EMP,
									CD_PROD 
								FROM 
									PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD  
								WHERE
									CD_CTR_DEPO = @CD_CTR_DEPO
									AND CD_FILIAL_DEPO_AUX=@CD_DEPOSITO	 
								UNION ALL
								SELECT DISTINCT 
									CD_EMP,
									CD_PROD 
								FROM 
									PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD_CPL
								WHERE
									CD_FILIAL = @CD_FIL_RES
									AND CD_CTR_DEPO=@CD_CTR_DEPO
									AND CD_FILIAL_DEPO_AUX=@CD_DEPOSITO   ) E ON
					P.CD_EMP  = E.CD_EMP AND
					P.CD_PROD = E.CD_PROD;
			end
			else -- Se for Cd principal ou Deposito Distribuidor(Ped. Eltr)
			-- Pega os produtos que os auxiliares nao trabalham
			begin
				if @DEPO_AUX_DISTRIBUIDOR =0
				begin
					-- Inicialmente todos os produtos participam
					update EST_PROD_TRANSF_PRODUTOS set HABILITA  = 1;

					UPDATE P 
					SET 
						HABILITA  = 0 --Desabilita os produtos q sao de outros CDs
					FROM 
						EST_PROD_TRANSF_PRODUTOS P
						INNER JOIN  ( SELECT 
										CD_EMP,
										CD_PROD 
									FROM 
										PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD  
									WHERE
										CD_CTR_DEPO = @CD_CTR_DEPO
										AND NOT CD_FILIAL_DEPO=@CD_DEPOSITO
									UNION ALL
									SELECT DISTINCT 
										CD_EMP,
										CD_PROD 
									FROM 
										PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD_CPL
									WHERE
										CD_FILIAL = @CD_FIL_RES
										AND CD_CTR_DEPO=@CD_CTR_DEPO
										AND NOT CD_FILIAL_DEPO=@CD_DEPOSITO) E ON
						P.CD_EMP  = E.CD_EMP AND
						P.CD_PROD = E.CD_PROD; 
				end 
			end 
			IF @POOL_RESSUPRIMENTO = 1
			BEGIN
				select	@AgdConsidEseg = case when isnull(NAO_CONSID_ESEG,0)=0 then 1 else 0 end ,
						@ParamAddAgd =	ISNULL((A.LEAD_TIME+ A.PARAM_EST),0)
				from 
					EST_PROD_RESSUP_AGENDAMENTO  a
				where 
					cd_emp=@cd_emp 
					and cd_agd_ressup= @cd_agenda;
				INSERT INTO EST_PROD_TRANSF_MEDIAF_PARAMS
				SELECT distinct
					p.CD_EMP,
					@CD_FIL_RES CD_FILIAL,
					grp.CD_GRP_RES,
					arvmerc.CD_GRP_PARAM,
					p.CD_PROD,
					P.EMAX+@ParamAddAgd EMAX,
					P.ESEG,
					P.PARAM_ESPECIAL,
					FDIAS = 0,
					P.CD_SIGLA,
					case when @DEPO_AUX_DISTRIBUIDOR = 1 and @UTILIZA_UN_RESSUP_DIST = 0 then 1
						else 
							case when ISNULL(P.QT_UNI_RESSUPRIMENTO,0) < 1 then 
								1 else ISNULL(P.QT_UNI_RESSUPRIMENTO,0) end  
					end QT_UNI_RESSUPRIMENTO,
					case when @DEPO_AUX_DISTRIBUIDOR = 1 and @UTILIZA_UN_RESSUP_DIST = 0  then 0
						else p.FLAG_RESSUPRIMENTO_CAIXA_FECHADA	end FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
					@AgdConsidEseg ConsideraEseg,
					arvMerc.TP_GRUPO_PARAMETRO,
					0 Remover
				FROM
					EST_PROD_TRANSF_GERAL a
					join EST_PROD_TRANSF_GERAL_CPL p on 
					a.cd_ctr = p.cd_Ctr
					INNER JOIN EST_PROD_TRANSF_PRODUTOS  Y ON 
						p.CD_EMP	= Y.CD_EMP  AND 
						p.CD_PROD	= Y.CD_PROD 
					LEFT JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA	arvmerc on 
					p.CD_EMP			= arvmerc.CD_EMP	   AND 
					@CD_FIL_RES			= arvmerc.CD_FILIAL	   AND 
					p.CD_PROD			= arvmerc.CD_PROD
					INNER JOIN V_EST_ARV_GRP_RESSUPRIMENTO grp ON
						grp.CD_EMP =@CD_EMP AND 
						grp.CD_FILIAL =@CD_FIL_RES AND 
						arvmerc.CD_ARV_MERC_LINHA  = grp.CD_ARV_MERC_LINHA
						and isnull(grp.CD_CTR_DEPO, @CD_CTR_DEPO) = @CD_CTR_DEPO
					-- TRATA A FILIAL DEPOSITO
					INNER JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL ctr ON
						grp.CD_EMP	  = ctr.CD_EMP AND
						grp.CD_FILIAL = ctr.CD_FILIAL 
				WHERE 
					p.CD_EMP = @CD_EMP
					-- TRATA A FILIAL DEPOSITO
					AND ctr.CD_CTR_DEPO = @CD_CTR_DEPO 
					and y.HABILITA =1
					AND (CASE WHEN @RESSUP_CAIXA_FECHADA = 1 THEN	
							1 ELSE p.FLAG_RESSUPRIMENTO_CAIXA_FECHADA END) = p.FLAG_RESSUPRIMENTO_CAIXA_FECHADA 
					AND A.DT_TRANSF= @HOJE
					AND A.STS_TRANSF=0
					AND P.SALDO>0
					AND A.CD_FIL_DEST=@CD_FIL_RES  
			END
			ELSE
			BEGIN
--Tag #A001			  

				IF OBJECT_ID('TEMPDB..#EST_PROD_CPL_RESSUP') IS NOT NULL 
				BEGIN
					DROP TABLE #EST_PROD_CPL_RESSUP
				END

				SELECT
					C.CD_EMP, 
					C.CD_PROD, 
					C.CD_FILIAL,
					CASE WHEN COALESCE(C.STS_PROD, 0) = 0 THEN
						COALESCE(B.STS_PROD, 0)
					ELSE
						COALESCE(C.STS_PROD, 0)
					END AS STS_PROD, 
					ISNULL(B.COMPRA_POR_SUPRIMENTO, C.COMPRA_POR_SUPRIMENTO) COMPRA_POR_SUPRIMENTO,
					c.CD_SIGLA,
					c.EMAX,
					c.ESEG
				INTO
					#EST_PROD_CPL_RESSUP
				FROM  
					EST_PROD_CPL c
					LEFT JOIN PRC_BANDEIRA_PRC_FILIAL f on 		
						c.CD_EMP		= F.CD_EMP AND
						c.CD_FILIAL		= F.CD_FILIAL
					LEFT JOIN EST_PROD_PRC_BANDEIRA b on 
							c.CD_EMP	  = b.CD_EMP		
						AND c.CD_PROD     = b.CD_PROD		
						AND f.CD_BANDEIRA = b.CD_BANDEIRA 		
				WHERE
					C.CD_EMP = @CD_EMP
					AND C.CD_FILIAL=@CD_FIL_RES
				
				CREATE INDEX IX_EST_PROD_CPL_RESSUP ON #EST_PROD_CPL_RESSUP (CD_EMP, CD_PROD, CD_FILIAL) INCLUDE (STS_PROD)

				INSERT INTO EST_PROD_TRANSF_MEDIAF_PARAMS
				SELECT distinct
					p.CD_EMP,
					cpl.CD_FILIAL,
					grp.CD_GRP_RES,
					arvmerc.CD_GRP_PARAM,
					p.CD_PROD,
					--sem parametro especial nem aumento, retorna valores originais da arvore mercadologica		
					CASE WHEN coalesce(pespSem.CD_GRP_PARAM, pespSemNovo.CD_EMP, 0) = 0 THEN
						ROUND(cpl.EMAX * (1 + ISNULL(pesp.EMAX/100, 0) + ISNULL( (isnull(aument.PERC_AUMENTO,0) + isnull(pEspCap.PERC_AUMENTO,0)) / 100, 0)), 0)
					ELSE
						ROUND( coalesce(pespSem.EMAX,pespSemNovo.EMAX ) * (1 + ISNULL(pesp.EMAX/100, 0) + ISNULL( (isnull(aument.PERC_AUMENTO,0) + isnull(pEspCap.PERC_AUMENTO,0)) /100, 0)), 0)
					END EMAX,
					CASE WHEN coalesce(pespSem.CD_GRP_PARAM, pespSemNovo.CD_EMP, 0) = 0 THEN
						ROUND(cpl.ESEG * (1 + ISNULL(pesp.ESEG/100, 0) + ISNULL( (isnull(aument.PERC_AUMENTO,0) + isnull(pEspCap.PERC_AUMENTO,0)) /100, 0)), 0)
					ELSE
						ROUND(coalesce(pespSem.ESEG,pespSemNovo.ESEG)  * (1 + ISNULL(pesp.ESEG/100, 0) + ISNULL( (isnull(aument.PERC_AUMENTO,0) + isnull(pEspCap.PERC_AUMENTO,0)) /100, 0)), 0)
					END ESEG,	
					PARAM_ESPECIAL = CASE WHEN pesp.CD_GRP_PARAM IS NULL THEN 0 ELSE 1 END,
					FDIAS = ISNULL(pesp.FDIAS, 0),
					cpl.CD_SIGLA,
					p.QT_UNI_RESSUPRIMENTO,
					p.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
					1 ConsideraEseg,
					arvMerc.TP_GRUPO_PARAMETRO,
					0 Remover
				FROM
					EST_PROD_TRANSF_PRODUTOS p  
					JOIN #EST_PROD_CPL_RESSUP cpl ON  
						p.CD_EMP			= cpl.CD_EMP	   AND 
						p.CD_PROD			= cpl.CD_PROD
					JOIN EST_PROD_EST_ARV_MERCADOLOGICA Arv  ON 
						p.CD_EMP  = Arv.CD_EMP AND
						p.CD_PROD = Arv.CD_PROD 
					INNER JOIN V_EST_ARV_GRP_RESSUPRIMENTO grp ON
						cpl.CD_EMP			   = grp.CD_EMP AND 
						cpl.CD_FILIAL		   = grp.CD_FILIAL AND 
						Arv.CD_ARV_MERC_LINHA  = grp.CD_ARV_MERC_LINHA
						and isnull(grp.CD_CTR_DEPO, @CD_CTR_DEPO) = @CD_CTR_DEPO
					LEFT JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA	arvmerc on 
					cpl.CD_EMP			= arvmerc.CD_EMP	   AND 
					cpl.CD_FILIAL		= arvmerc.CD_FILIAL	   AND 
					cpl.CD_PROD			= arvmerc.CD_PROD
					LEFT JOIN EST_ARV_MD_F_GRP_PARAM_ESPECIAIS_DIA_SEMANA pespSem	ON
						arvmerc.CD_EMP			= pespSem.CD_EMP AND 
						arvmerc.CD_GRP_PARAM	= pespSem.CD_GRP_PARAM AND
						pespSem.DIA_SEMANA		= DATEPART(WEEKDAY,@HOJE) AND
						pespSem.FLAG_APLICACAO IN (0,1)			
					LEFT JOIN EST_PARAM_COMPRAS_GRUPO_ESPECIAIS_DIA_SEMANA pespSemNovo	ON
						arvmerc.CD_EMP			= pespSemNovo.CD_EMP	AND 
						arvmerc.CD_FILIAL		= pespSemNovo.CD_FILIAL AND 
						arvmerc.CD_SIGLA			= pespSemNovo.CD_SIGLA	AND 
						arvmerc.CD_GRP_PARAM		= pespSemNovo.CD_CTR AND 
						arvmerc.CD_ARV_MERC_LINHA	= pespSemNovo.CD_ARV_MERC_LINHA  AND
						pespSemNovo.DIA_SEMANA		= DATEPART(WEEKDAY,@HOJE) AND
						pespSemNovo.FLAG_APLICACAO IN (0,1)		
					LEFT JOIN #PARAM_CATEGORIA_LINHA_DEPTO pEspCap on
						p.CD_EMP	= pEspCap.CD_EMP AND 
						p.CD_PROD	= pEspCap.CD_PROD AND 
						pEspCap.PERC_AUMENTO >0
					LEFT JOIN EST_ARV_MD_F_GRP_PARAM_ESPECIAIS pesp	ON
						pesp.CD_EMP			= arvmerc.CD_EMP AND 
						pesp.CD_GRP_PARAM	= arvmerc.CD_GRP_PARAM AND 
						(pesp.FDIAS_ULT_ATU IS NULL 
								OR DATEADD(DAY, pesp.FDIAS, pesp.FDIAS_ULT_ATU) <= @HOJE AND pesp.DT_INICIAL<=@HOJE)
					LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_PERC_AUMENTO aument ON --aumento de percentual do Emax e Eseg por data
						aument.CD_EMP			= cpl.CD_EMP AND 
						aument.CD_SIGLA			= cpl.CD_SIGLA AND 
						aument.DT_RESSUP		= @HOJE 
					--- AS FILIAIS POR LINHA QUE NAO RODAM HOJE
					LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_DIA_SEMANA_PRC_FILIAL_LINHA N_LJ_LINHA ON
						GRP.CD_EMP					= N_LJ_LINHA.CD_EMP AND
						GRP.CD_FILIAL				= N_LJ_LINHA.CD_FILIAL AND
						GRP.CD_ARV_MERC_LINHA		= N_LJ_LINHA.CD_ARV_MERC_LINHA  AND 
						N_LJ_LINHA.DIA_SEMANA		= @DIA_SEMANA
					LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_LINHA_DIA_SEMANA N_L ON
						GRP.CD_EMP					= N_L.CD_EMP AND 
						GRP.CD_ARV_MERC_LINHA		= N_L.CD_ARV_MERC_LINHA  AND 
						N_L.DIA_SEMANA				= @DIA_SEMANA
					LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_FABRIC_DIA_SEMANA N_F ON
						P.CD_EMP					= N_F.CD_EMP AND 
						P.CD_FABRIC					= N_F.CD_FABRIC  AND 
						N_F.DIA_SEMANA				= @DIA_SEMANA
					LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_DIA_SEMANA_PRC_FILIAL N_S_LJ ON
						grp.CD_EMP					= N_S_LJ.CD_EMP AND 
						grp.CD_FILIAL				= N_S_LJ.CD_FILIAL  AND 
						N_S_LJ.DIA_SEMANA			= @DIA_SEMANA 
					LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR_FILIAL N_DT_LJ ON
						grp.CD_EMP					= N_DT_LJ.CD_EMP AND 
						grp.CD_FILIAL				= N_DT_LJ.CD_FILIAL  AND 
						N_DT_LJ.DT_NAO_RESSUP		=@HOJE
					LEFT JOIN EST_ARV_GRP_RESSUPRIMENTO_NAO_EXECUTAR N_GRP ON
						grp.CD_EMP					= N_GRP.CD_EMP AND 
						grp.CD_GRP_RES				= N_GRP.CD_GRP_RES  AND 
						N_GRP.DT_NAO_RESSUP			= @HOJE
					-- TRATA A FILIAL DEPOSITO
					INNER JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL ctr ON
						grp.CD_EMP	  = ctr.CD_EMP AND
						grp.CD_FILIAL = ctr.CD_FILIAL 
				WHERE 
					cpl.CD_EMP = @CD_EMP
					AND P.STS_PROD IN (SELECT 0 STS 
										UNION 
										SELECT CASE WHEN @NAO_RESSUP_PROD_BLOQ_EMP =1 THEN 0 
													ELSE 2 END STS)
					-- TRATA A FILIAL DEPOSITO
					AND ctr.CD_CTR_DEPO = @CD_CTR_DEPO 
					and p.HABILITA =1
					-- RETIRA OS PRODUTOS BLOQUEADOS OU INATIVOS
					AND grp.CD_FILIAL		= cpl.CD_FILIAL
					AND cpl.STS_PROD  = 0 
					AND (CASE WHEN @RESSUP_CAIXA_FECHADA = 1 THEN	
							1 ELSE p.FLAG_RESSUPRIMENTO_CAIXA_FECHADA END) = p.FLAG_RESSUPRIMENTO_CAIXA_FECHADA 
					AND N_LJ_LINHA.CD_EMP IS NULL  -- AS FILIAIS POR LINHA QUE NAO RODAM HOJE
					AND N_L.CD_EMP		  IS NULL  -- AS LINHAS QUE NAO RODAM HOJE
					AND N_F.CD_EMP		  IS NULL  -- OS FABRICANTES QUE NAO RODAM HOJE			 
					AND N_S_LJ.CD_EMP 	  IS NULL  -- AS FILIAIS QUE NAO RODAM HOJE 
					AND N_DT_LJ.CD_EMP	  IS NULL  -- AS FILIAIS QUE NAO RODAM HOJE POR DATA 
					AND N_GRP.CD_EMP	  IS NULL  -- OS GRUPOS QUE NAO RODAM HOJE POR DATA  
					AND  cpl.CD_FILIAL=@CD_FIL_RES 
					AND  grp.CD_FILIAL=@CD_FIL_RES 
					--SE FOR DEPOSITO AUXILIAR, MANDA SOMENTE OS PRODUTOS CUJO TIPO DE COMPRA SEJA RESSUP OU SUP-RESSUP
					AND COALESCE(cpl.COMPRA_POR_SUPRIMENTO, p.COMPRA_POR_SUPRIMENTO, 0) 
							IN (SELECT ID FROM #TMP_COMPRA_POR_SUPRIMENTO) option (recompile);
			END
			FETCH NEXT FROM ljs INTO @CD_FIL_RES
		END
	CLOSE ljs
	DEALLOCATE ljs

IF NOT EXISTS(SELECT * FROM EST_PROD_TRANSF_PRODUTOS)
 BEGIN
	print 'EST_PROD_TRANSF_MEDIAF_PARAMS vazia'
	GOTO SemNecessidade
 END

/*****************************************************************************************************************************************************************/
-- Criacao indexes
/*****************************************************************************************************************************************************************/
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
			,'Cria indexes para melhorar performance'
			,'INFORMACAO'
			, 900
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_MEDIAF_PARAMS'
			,'RESSUPRIMENTO')
	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_MEDIAF_PARAMS_CD_FILIAL_CD_PROD ON [EST_PROD_TRANSF_MEDIAF_PARAMS] ([CD_FILIAL],[CD_PROD])
						INCLUDE ([CD_EMP],[CD_GRP_RES],[EMAX],[ESEG],[PARAM_ESPECIAL],[QT_UNI_RESSUPRIMENTO],[FLAG_RESSUPRIMENTO_CAIXA_FECHADA],[ConsideraEseg])
	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_MEDIAF_PARAMS_01 ON EST_PROD_TRANSF_MEDIAF_PARAMS (CD_EMP, TpGrupoParam) INCLUDE (CD_FILIAL) 
	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_MEDIAF_PARAMS_02 ON EST_PROD_TRANSF_MEDIAF_PARAMS ([CD_EMP],[CD_FILIAL],[TpGrupoParam]) 
	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_MEDIAF_PARAMS_03 ON EST_PROD_TRANSF_MEDIAF_PARAMS ([CD_FILIAL],[CD_PROD])  
	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_MEDIAF_PARAMS_04 ON EST_PROD_TRANSF_MEDIAF_PARAMS (TpGrupoParam)  
	CREATE NONCLUSTERED INDEX IX_EST_PROD_TRANSF_MEDIAF_PARAMS_05 ON EST_PROD_TRANSF_MEDIAF_PARAMS ([CD_EMP],[PARAM_ESPECIAL],[FDIAS]) INCLUDE ([CD_GRP_PARAM])


/*****************************************************************************************************************************************************************/
--Confere os tipo de parametro de compras a ser utilizado.
/*****************************************************************************************************************************************************************/

INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
			,'Confere os tipo de parametro de compras a ser utilizado.'
			,'INFORMACAO'
			, 921
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_MEDIAF_PARAMS'
			,'RESSUPRIMENTO')

	IF EXISTS(SELECT * FROM PRC_EMP_CONFIG WHERE  CD_EMP = 1 AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'
		AND VALOR='1')
	BEGIN
		DELETE FROM  EST_PROD_TRANSF_MEDIAF_PARAMS 
		WHERE TpGrupoParam=0;
	END
	else
	begin
		DELETE FROM  P
		FROM 
			EST_PROD_TRANSF_MEDIAF_PARAMS P
			JOIN PRC_FILIAL_CONFIG C ON 
			P.CD_EMP = C.CD_EMP AND
			P.CD_FILIAL = C.CD_FILIAL		
		WHERE
			p.TpGrupoParam=0
			AND p.CD_EMP = @CD_EMP 
			AND c.CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS' 
			AND c.VALOR='1';
		DELETE FROM  P
		FROM 
			EST_PROD_TRANSF_MEDIAF_PARAMS P
		where
			p.TpGrupoParam=1
			and CD_FILIAL IN ( SELECT F.CD_FILIAL 
								FROM 
									PRC_FILIAL F
									LEFT JOIN PRC_FILIAL_CONFIG C ON 
									F.CD_EMP    = C.CD_EMP AND
									F.CD_FILIAL = C.CD_FILIAL		
									AND c.CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS' 
									AND c.VALOR='1'
								WHERE C.CD_EMP IS NULL ) 
			AND p.CD_EMP = @CD_EMP  ; 
	end
/*****************************************************************************************************************************************************************/
	--Verifica parametros duplicados.
	if exists(SELECT TOP 1 COUNT(CD_EMP) 
				FROM EST_PROD_TRANSF_MEDIAF_PARAMS 
				GROUP BY CD_FILIAL, CD_PROD 
				HAVING  COUNT(CD_EMP) > 1 )
	begin
		print 'Foram encontrados parametros de configurao duplicados. Corrija os parametros. Removendo duplicidades!'
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Foram encontrados parametros de configurao duplicados. Corrija os parametros. Removendo duplicidades! - 001'
			,'DELETE'
			, 945
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_MEDIAF_PARAMS'
			,'RESSUPRIMENTO')

		--RAISERROR ( ' Foram encontrados parametros de configuracao duplicados. Corrija os parametros. Ressuprimento abortado!', 16, 1); 
		--return;
		CREATE NONCLUSTERED INDEX IX_TMP_EST_PROD_TRANSF_MEDIAF_PARAMS ON EST_PROD_TRANSF_MEDIAF_PARAMS
							(CD_PROD, CD_FILIAL);
		update a
		set
			remover=1
		FROM
			EST_PROD_TRANSF_MEDIAF_PARAMS a
			JOIN(SELECT
							CD_FILIAL
							, CD_PROD
							, COUNT(*) qtde
					FROM
							EST_PROD_TRANSF_MEDIAF_PARAMS
					GROUP BY
								CD_FILIAL
							, CD_PROD
					HAVING COUNT(CD_EMP) > 1
					) d ON a.cd_filial = d.cd_filial
							AND a.cd_prod = d.cd_prod;
		INSERT INTO EST_PROD_TRANSF_MEDIAF_PARAMS
		SELECT
			DISTINCT A.CD_EMP
			, A.CD_FILIAL
			, A.CD_GRP_RES
			, A.CD_GRP_PARAM
			, A.CD_PROD
			, A.EMAX
			, A.ESEG
			, A.PARAM_ESPECIAL
			, A.FDIAS
			, A.CD_SIGLA
			, A.QT_UNI_RESSUPRIMENTO
			, A.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
			, A.ConsideraEseg
			, A.TpGrupoParam
			, 0 Remover
		FROM
				EST_PROD_TRANSF_MEDIAF_PARAMS a
				JOIN(SELECT
								CD_FILIAL
								, CD_PROD
								, COUNT(*) qtde
						FROM
								EST_PROD_TRANSF_MEDIAF_PARAMS
						GROUP BY
									CD_FILIAL
								, CD_PROD
						HAVING COUNT(CD_EMP) > 1
						) d ON a.cd_filial = d.cd_filial
								AND a.cd_prod = d.cd_prod;
		CREATE NONCLUSTERED INDEX IX_TMP_REMOVER_EST_PROD_TRANSF_MEDIAF_PARAMS ON EST_PROD_TRANSF_MEDIAF_PARAMS
							(remover);
		delete from EST_PROD_TRANSF_MEDIAF_PARAMS where remover =1;
		--------------------------------------------------------
		
		if exists(SELECT TOP 1 COUNT(CD_EMP) 
				FROM EST_PROD_TRANSF_MEDIAF_PARAMS 
				GROUP BY CD_FILIAL, CD_PROD 
				HAVING  COUNT(CD_EMP) > 1 )
		begin
			DECLARE @DuplicadoFilial int ,@DuplicadoProd int, @DuplicadoQtde int ;
			declare c_Duplicado  CURSOR FAST_FORWARD FOR 
			SELECT   CD_FILIAL, CD_PROD , count(*) qtde
							FROM EST_PROD_TRANSF_MEDIAF_PARAMS 
							GROUP BY CD_FILIAL, CD_PROD 
							HAVING  COUNT(CD_EMP) > 1  
			OPEN c_Duplicado
			FETCH NEXT FROM c_Duplicado INTO @DuplicadoFilial,@DuplicadoProd, @DuplicadoQtde
			WHILE @@FETCH_STATUS = 0
				BEGIN
					--PRINT 'Remove produto duplicado lj ' + CONVERT(VARCHAR, @DuplicadoFilial)+	' Prod '+  CONVERT(VARCHAR, @DuplicadoProd)
					INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
					VALUES (GETDATE(),GETDATE()
						,'Removendo duplicidades! - 002'
						,'DELETE'
						, 1027
						,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
						,'EST_PROD_TRANSF_MEDIAF_PARAMS'
						,'RESSUPRIMENTO')
						 
					 delete top(@DuplicadoQtde-1)
		 				FROM EST_PROD_TRANSF_MEDIAF_PARAMS 
							 where 
								cd_filial=@DuplicadoFilial
								and CD_PROD= @DuplicadoProd;
					FETCH NEXT FROM c_Duplicado INTO  @DuplicadoFilial,@DuplicadoProd, @DuplicadoQtde
				END
			CLOSE c_Duplicado;
			DEALLOCATE c_Duplicado; 
		end
	end
	alter table EST_PROD_TRANSF_MEDIAF_PARAMS add PRIMARY KEY CLUSTERED 
	(	[CD_PROD] ASC,
		[CD_FILIAL] ASC,
		[CD_EMP] ASC
	);
/*********************************************************************************************************************/
-- A G EN D A   D O    R E S S U P R I M E N T O
/*********************************************************************************************************************/
	--Agenda do pool  tratada na rotina do pool
	if @POOL_RESSUPRIMENTO=1
		set @UTILIZA_AGENDA = 0
/*********************************************************************************************************************/
	IF @UTILIZA_AGENDA = 1
	BEGIN
		/*INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Filtros de agendamento do ressuprimento '
			,'INSERT'
			, 1061
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_AGENDAMENTO'
			,'RESSUPRIMENTO')

		INSERT INTO EST_PROD_TRANSF_AGENDAMENTO  (CD_EMP,CD_FILIAL,CD_PROD,PARAM_ADICIONAL,FLAG_NAO_ENVIAR_PBM,DIARIO)
		SELECT 
			A.CD_EMP,
			P.CD_FILIAL,
			W.CD_PROD, 
			MAX(A.LEAD_TIME + A.PARAM_EST) PARAM_ADD,
			MAX(ISNULL(A.FLAG_NAO_ENVIAR_PBM,0)),
			5 DIARIO -- se for agendamento antigo considera Eseg
		FROM  
			EST_PROD_RESSUP_AGENDAMENTO A
			INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_PRC_FILIAL p on
			A.CD_EMP		= P.CD_EMP AND
			A.CD_AGD_RESSUP  = P.CD_AGD_RESSUP
			INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_EST_PROD_FABRIC f on
			A.CD_EMP		= F.CD_EMP AND
			A.CD_AGD_RESSUP  = F.CD_AGD_RESSUP
			INNER JOIN EST_PROD_RESSUP_AGENDAMENTO_EST_ARV_MERC_LINHA l on
			A.CD_EMP		= L.CD_EMP AND
			A.CD_AGD_RESSUP  = L.CD_AGD_RESSUP 
			INNER JOIN EST_PROD Y on 
			F.CD_FABRIC  = Y.CD_FABRIC 
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA W on
			L.CD_EMP			 = W.CD_EMP AND
			L.CD_ARV_MERC_LINHA  = W.CD_ARV_MERC_LINHA AND
			Y.CD_PROD			 = W.CD_PROD
		WHERE
			A.CD_EMP	= @CD_EMP
			AND A.CD_FILIAL_DEPO	= @CD_DEPOSITO 
			AND	(CASE WHEN @DIA_SEMANA =1 THEN A.DOMINGO
					WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
					WHEN @DIA_SEMANA =3 THEN A.TERCA  
					WHEN @DIA_SEMANA =4 THEN A.QUARTA
					WHEN @DIA_SEMANA =5 THEN A.QUINTA  
					WHEN @DIA_SEMANA =6 THEN A.SEXTA  
					WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1 
		GROUP BY 
			A.CD_EMP,
			P.CD_FILIAL,
			W.CD_PROD;   

		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Filtros de agendamento do ressuprimento - Mod 2 '
			,'INSERT'
			, 1110
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_AGENDAMENTO'
			,'RESSUPRIMENTO')
		INSERT INTO EST_PROD_TRANSF_AGENDAMENTO  (CD_EMP,CD_FILIAL,CD_PROD,PARAM_ADICIONAL,FLAG_NAO_ENVIAR_PBM,DIARIO)
		SELECT DISTINCT
			T.CD_EMP,
			T.CD_FILIAL,
			T.CD_PROD,
			0 PARAM_ADD,
			ISNULL(A.FLAG_NAO_ENVIAR_PBM,0),
			5 DIARIO -- se for agendamento antigo considera Eseg 
		FROM
			(SELECT DISTINCT
					T.CD_EMP,
					P.CD_PROD,
					F.CD_FILIAL
				FROM 
					EST_PROD_TABLOIDE T
					INNER JOIN EST_PROD_TABLOIDE_CPL P ON 
					T.CD_EMP = P.CD_EMP AND
					T.CD_TABLOIDE = P.CD_TABLOIDE
					INNER JOIN EST_PROD_TABLOIDE_FILIAL F ON 
					T.CD_EMP		= F.CD_EMP AND
					T.CD_TABLOIDE	= F.CD_TABLOIDE
				WHERE T.FLAG_VIGENCIA=1) T
			LEFT JOIN EST_PROD_TRANSF_AGENDAMENTO TA ON 
			T.CD_EMP	= TA.CD_EMP AND
			T.CD_PROD	= TA.CD_PROD AND
			T.CD_FILIAL	= TA.CD_FILIAL 
			INNER JOIN EST_PROD_RESSUP_AGENDAMENTO A ON 
			T.CD_EMP	= A.CD_EMP  
		WHERE
			A.CD_EMP	= @CD_EMP
			AND TA.CD_EMP IS NULL
			AND A.INCLUI_TABLOIDE=1
			AND A.CD_FILIAL_DEPO	= @CD_DEPOSITO 
			AND	(CASE WHEN @DIA_SEMANA =1 THEN A.DOMINGO
				WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
				WHEN @DIA_SEMANA =3 THEN A.TERCA  
				WHEN @DIA_SEMANA =4 THEN A.QUARTA
				WHEN @DIA_SEMANA =5 THEN A.QUINTA  
				WHEN @DIA_SEMANA =6 THEN A.SEXTA  
				WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1;
		/**************************************************************************/
		--Agendamento Novo
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Filtros de agendamento do ressuprimento - Mod Novo '
			,'INSERT'
			, 1160
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_AGENDA_COMPRA'
			,'RESSUPRIMENTO');


		Create Table #TmpAgenda (CD_CTR_AGENDA INT, CD_PROD INT);
		insert into #TmpAgenda
		SELECT 
			A.CD_CTR_AGENDA, 
			P.CD_PROD 
		FROM 
			EST_PROD_AGENDA_COMPRA A
			CROSS APPLY(SELECT CD_PROD  FROM dbo.UFD_EST_PROD_AGENDA_COMPRA_PRODUTOS (A.CD_EMP,A.CD_CTR_AGENDA)) P
		WHERE
			A.TIPO_AGENDA= 2
			and STS_AGENDA=0 
			AND A.CD_EMP=@CD_EMP
			AND A.CD_FILIAL_DEPO = @CD_DEPOSITO
			AND (CASE WHEN @DIA_SEMANA =1 THEN A.DOMINGO
					WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
					WHEN @DIA_SEMANA =3 THEN A.TERCA  
					WHEN @DIA_SEMANA =4 THEN A.QUARTA
					WHEN @DIA_SEMANA =5 THEN A.QUINTA  
					WHEN @DIA_SEMANA =6 THEN A.SEXTA  
					WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1 
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Filtros de agendamento do ressuprimento - Mod Novo 2'
			,'INSERT'
			, 1190
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_AGENDA_COMPRA'
			,'RESSUPRIMENTO');

		INSERT INTO EST_PROD_TRANSF_AGENDAMENTO  (CD_EMP,CD_FILIAL,CD_PROD,PARAM_ADICIONAL,FLAG_NAO_ENVIAR_PBM,DIARIO)
		SELECT   
			A.CD_EMP,
			F.CD_FILIAL,
			P.CD_PROD, 
			MAX(ISNULL((A.LEAD_TIME+ A.PARAM_EST),0) ) PARAM_ADICIONAL,
			MAX(ISNULL(A.FLAG_NAO_ENVIAR_PBM,0))	   FLAG_NAO_ENVIAR_PBM,
			MAX(ISNULL(A.AGD_DIARIO,0)) AGD_DIARIO
		FROM 
			EST_PROD_AGENDA_COMPRA A
			JOIN (SELECT DISTINCT
						A.CD_EMP,
						A.CD_CTR_AGENDA,
						COALESCE(F.CD_FILIAL, BF.CD_FILIAL, 0) CD_FILIAL
					FROM 
						EST_PROD_AGENDA_COMPRA A
						LEFT JOIN EST_PROD_AGENDA_COMPRA_PRC_BANDEIRA B ON 
						A.CD_CTR_AGENDA = B.CD_CTR_AGENDA
						LEFT JOIN PRC_BANDEIRA_PRC_FILIAL BF ON 
						B.CD_BANDEIRA = BF.CD_BANDEIRA
						LEFT JOIN EST_PROD_AGENDA_COMPRA_PRC_FILIAL F ON 
						A.CD_CTR_AGENDA = F.CD_CTR_AGENDA
					WHERE
						A.TIPO_AGENDA= 2
						AND A.CD_EMP=@CD_EMP
						AND A.CD_FILIAL_DEPO = @CD_DEPOSITO) F ON 
			A.CD_EMP		  = f.CD_EMP AND
			A.CD_CTR_AGENDA  = f.CD_CTR_AGENDA
			JOIN #TmpAgenda p ON 
			A.CD_CTR_AGENDA = p.CD_CTR_AGENDA 

			LEFT JOIN EST_PROD_TRANSF_AGENDAMENTO ON
				F.CD_FILIAL = EST_PROD_TRANSF_AGENDAMENTO.CD_FILIAL AND 
				P.CD_PROD	  = EST_PROD_TRANSF_AGENDAMENTO.CD_PROD
		WHERE
			A.TIPO_AGENDA= 2
			and STS_AGENDA=0
			AND EST_PROD_TRANSF_AGENDAMENTO.CD_PROD IS NULL
			AND A.CD_EMP=@CD_EMP
			AND A.CD_FILIAL_DEPO = @CD_DEPOSITO
			AND (CASE WHEN @DIA_SEMANA =1 THEN A.DOMINGO
					WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
					WHEN @DIA_SEMANA =3 THEN A.TERCA  
					WHEN @DIA_SEMANA =4 THEN A.QUARTA
					WHEN @DIA_SEMANA =5 THEN A.QUINTA  
					WHEN @DIA_SEMANA =6 THEN A.SEXTA  
					WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1  
		 GROUP BY 
			A.CD_EMP,
			F.CD_FILIAL,
			P.CD_PROD;
/**********************************************************************************/			
	-- Curva
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Filtros de agendamento - Curva'
		,'SELECT'
		, 1160
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_AGENDA_COMPRA'
		,'RESSUPRIMENTO');

	SELECT  DISTINCT 
		A.CD_EMP,
		F.CD_FILIAL,
		S.CD_SIGLA
		INTO #TMP_TBL_SIGLA
	FROM 
		EST_PROD_AGENDA_COMPRA A
		JOIN (SELECT DISTINCT
					A.CD_EMP,
					A.CD_CTR_AGENDA,
					COALESCE(F.CD_FILIAL, BF.CD_FILIAL, 0) CD_FILIAL
				FROM 
					EST_PROD_AGENDA_COMPRA A
					LEFT JOIN EST_PROD_AGENDA_COMPRA_PRC_BANDEIRA B ON 
					A.CD_CTR_AGENDA = B.CD_CTR_AGENDA
					LEFT JOIN PRC_BANDEIRA_PRC_FILIAL BF ON 
					B.CD_BANDEIRA = BF.CD_BANDEIRA
					LEFT JOIN EST_PROD_AGENDA_COMPRA_PRC_FILIAL F ON 
					A.CD_CTR_AGENDA = F.CD_CTR_AGENDA
				WHERE
					A.TIPO_AGENDA= 2
					AND A.CD_EMP=@CD_EMP
					AND A.CD_FILIAL_DEPO = @CD_DEPOSITO) F ON 
		A.CD_EMP		  = f.CD_EMP AND
		A.CD_CTR_AGENDA  = f.CD_CTR_AGENDA
		JOIN EST_PROD_AGENDA_COMPRA_EST_PROD_CURVA_SIGLA  S ON 
		A.CD_EMP			= S.CD_EMP AND
		A.CD_CTR_AGENDA		= S.CD_CTR_AGENDA
	WHERE
		A.TIPO_AGENDA= 2
		AND STS_AGENDA=0			
		AND A.CD_EMP=@CD_EMP
		AND A.CD_FILIAL_DEPO = @CD_DEPOSITO
		AND (CASE WHEN @DIA_SEMANA =1 THEN A.DOMINGO
					WHEN @DIA_SEMANA =2 THEN A.SEGUNDA  
					WHEN @DIA_SEMANA =3 THEN A.TERCA  
					WHEN @DIA_SEMANA =4 THEN A.QUARTA
					WHEN @DIA_SEMANA =5 THEN A.QUINTA  
					WHEN @DIA_SEMANA =6 THEN A.SEXTA  
					WHEN @DIA_SEMANA =7 THEN A.SABADO END) = 1;
	IF EXISTS(SELECT * FROM #TMP_TBL_SIGLA)
	BEGIN
		DELETE FROM P 
		FROM 
			EST_PROD_TRANSF_MEDIAF_PARAMS P 
			LEFT JOIN #TMP_TBL_SIGLA S ON 
			P.CD_EMP	= S.CD_EMP AND 
			P.CD_FILIAL = S.CD_FILIAL AND 
			P.CD_SIGLA	= S.CD_SIGLA
		WHERE
			S.CD_EMP IS NULL;
	END  
	--Excluir produtosXFilial nao agendados.
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Excluir produtosXFilial nao agendados.' 
		,'SELECT'
		, 1313
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_TRANSF_MEDIAF_PARAMS'
		,'RESSUPRIMENTO');

	DELETE FROM P
	FROM	
		EST_PROD_TRANSF_MEDIAF_PARAMS P
		LEFT JOIN EST_PROD_TRANSF_AGENDAMENTO A ON
		P.CD_EMP   = A.CD_EMP AND
		P.CD_FILIAL= A.CD_FILIAL AND
		P.CD_PROD  = A.CD_PROD
	WHERE
		A.CD_EMP IS NULL;  
	--Deletar dos produtos PBM
	IF EXISTS ( SELECT TOP 1 * FROM EST_PROD_TRANSF_AGENDAMENTO
		WHERE FLAG_NAO_ENVIAR_PBM =1)
		begin
			 DELETE FROM P
			 FROM	
			 	EST_PROD_TRANSF_MEDIAF_PARAMS P
			 	INNER JOIN EST_PROD_RC_CLI_CONV A ON
			 	P.CD_EMP   = A.CD_EMP AND
			 	P.CD_PROD  = A.CD_PROD
			 WHERE
			 	REPOSICAO='S'
		end
	----

		UPDATE P
		SET
			EMAX =EMAX+A.PARAM_ADICIONAL,
			ConsideraEseg = case when A.DIARIO >4 then 1  --Se for agendamento diario vai considerar o Eseg..
							else 0 end 
		FROM	
			EST_PROD_TRANSF_MEDIAF_PARAMS P
			INNER JOIN EST_PROD_TRANSF_AGENDAMENTO A ON
			P.CD_EMP   = A.CD_EMP AND
			P.CD_FILIAL= A.CD_FILIAL AND
			P.CD_PROD  = A.CD_PROD; 
			
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
				,'Carregou agendamento do ressuprimento '
				,'INFORMACAO'
				, 1358
				,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
				,'EST_PROD_TRANSF_MEDIAF_PARAMS'
				,'RESSUPRIMENTO');
				*/


		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Executa rotina de filtros de agendamento do ressuprimento '
			,'PROCEDURE'
			, 1396
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'P_EST_PROD_TRANSF_AGENDAS_PROD'
			,'RESSUPRIMENTO')

		Exec P_EST_PROD_TRANSF_AGENDAS_PROD @CD_EMP, @CD_DEPOSITO, @DIA_SEMANA

		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Fim da rotina de filtros de agendamento do ressuprimento '
			,'PROCEDURE'
			, 1409
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'P_EST_PROD_TRANSF_AGENDAS_PROD'
			,'RESSUPRIMENTO')

		
	END
/*********************************************************************************************************************/
/*********************************************************************************************************************/
--Se for distribuidora retira os inativos	
IF @DEPO_AUX_DISTRIBUIDOR=1
begin
	DELETE FROM P
	FROM	
		EST_PROD_TRANSF_MEDIAF_PARAMS P
		INNER JOIN EST_PROD A ON
		P.CD_EMP   = A.CD_EMP AND
		P.CD_PROD  = A.CD_PROD
	WHERE	
		A.STS_PROD<>0
	DELETE FROM P
	FROM	
		EST_PROD_TRANSF_MEDIAF_PARAMS P
		INNER JOIN EST_PROD_CPL A ON
		P.CD_EMP   = A.CD_EMP AND
		P.CD_FILIAL   = A.CD_FILIAL AND
		P.CD_PROD  = A.CD_PROD
	WHERE	
		A.STS_PROD<>0
end
	PRINT 'Carregou a tabela de parametros  EST_PROD_TRANSF_MEDIAF_PARAMS - Time : ' + convert(varchar, getdate(), 108);
IF @CONSULTA%2=1 AND @CD_PROD IS NOT NULL  --DEBUG
	BEGIN
		PRINT 'REGISTROS DE PARAMETROS DE MEDIA F - EST_PROD_TRANSF_MEDIAF_PARAMS';
		SELECT * FROM EST_PROD_TRANSF_MEDIAF_PARAMS; --DEBUG
	END
ELSE 
	PRINT 'CALCULADOS PARAMETROS DE MEDIA F (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';
/**********************************************************************************************************/
--===========INCLUI O PROCESSAMENTO DE FALTAS DE OUTRO DEPOSITO =================
/**********************************************************************************************************/ 
IF @CD_DEPOSITO_FALTA > 0
BEGIN
	 
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
				, 'Processando faltas do deposito ' + convert(varchar, @CD_DEPOSITO_FALTA)
				,'INSERT'
				, 1409
				,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
				,'EST_PROD_TRANSF_FALTAS'
				,'RESSUPRIMENTO');

	insert into EST_PROD_TRANSF_MEDIAF_PARAMS(	CD_EMP,CD_FILIAL,CD_GRP_RES,CD_GRP_PARAM,CD_PROD,EMAX,ESEG,
												PARAM_ESPECIAL,FDIAS,CD_SIGLA,QT_UNI_RESSUPRIMENTO,
												FLAG_RESSUPRIMENTO_CAIXA_FECHADA,ConsideraEseg,TpGrupoParam)
	select
		 F.CD_EMP
		,F.CD_FILIAL_FALTA AS CD_FILIAL
		,F.CD_GRP_RES
		,F.CD_GRP_PARAM
		,F.CD_PROD
		,F.EMAX
		,F.ESEG
		,F.PARAM_ESPECIAL
		,F.FDIAS
		,F.CD_SIGLA
		,F.QT_UNI_RESSUPRIMENTO
		,F.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
		,F.ConsideraEseg
		,F.TpGrupoParam
	from 
		EST_PROD_TRANSF_FALTAS F
			LEFT JOIN EST_PROD_TRANSF_MEDIAF_PARAMS M ON 
			F.CD_EMP			= M.CD_EMP AND 
			F.CD_FILIAL_FALTA   = M.CD_FILIAL AND
			F.CD_PROD   = M.CD_PROD  
	WHERE 
			F.DT_CAD	 = @HOJE
		AND F.CD_EMP = @CD_EMP
		AND F.CD_FILIAL = @CD_DEPOSITO_FALTA
		AND M.CD_EMP IS NULL;
END	 
/**********************************************************************************************************/
--===========CALCULO PREVIO DA NECESSIDADE DE RESSUPRIMENTO (QT_EST < ESEG)=================
/**********************************************************************************************************/ 
PRINT 'Inicio dos registro de necessidade de ressuprimento ' + CONVERT(VARCHAR, GETDATE(), 108);
if @POOL_RESSUPRIMENTO=1
	begin
		;WITH BASE1 AS (SELECT     
				a.CD_FIL_DEST CD_FILIAL, 
				b.CD_PROD, 
				EMAX = B.QT_EMAX,												
				ESEG = B.QT_ESEG, 		
				QT_EST		= CASE WHEN  B.QT_PEND > 0 THEN B.QT_PEND ELSE 0 END,	
				QT_MEDIAF	= b.MEDIAF,
				arv.CD_GRP_RES,
				mdf.CD_SIGLA,
				arv.PARAM_ESPECIAL,
				ESEGCAD		= B.ESEG,
				EMAXCAD		= B.EMAX,
				CD_GRP_PRT	= ISNULL(pr.CD_GRP_PRT,0),   --localizacao dos produtos (grupo de prateleiras)
				VLR_CUSTO = CASE WHEN @TP_PRECO <> 9 THEN -- Se for preco parametrizado 
								dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD, @TP_PRECO,2, a.CD_FIL_DEST) -- Preco parametrizado 
							ELSE -- Se nao for preco parametrizado
								CASE WHEN ISNULL(FLAG_FILIAL_FRANQUIA,0) = 0 THEN
									CASE WHEN @CD_DEPO_OPERADOR = 1 THEN
										CASE WHEN dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,8,2,a.CD_FIL_DEST) =0 THEN
												dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,14,2,a.CD_FIL_DEST) --Ressuprimento
											ELSE 
												dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,8,2,a.CD_FIL_DEST) 
											END  --Preco Operador Log	 
									ELSE
										dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD, @TP_PRECO,2,a.CD_FIL_DEST) -- Preco parametrizado
									END
								ELSE
									dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,13,2,a.CD_FIL_DEST) --Preco Franquia	 
								END
							END, 
				ISNULL(dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,0,2,a.CD_FIL_DEST),0) VLR_CUSTO_MD,-- Custo Medio para auditorias posteriores 
				B.QT_UNI_RESSUPRIMENTO,
				B.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,			
				PERC_DESC = dbo.UFD_EST_PROD_DESCONTO_RESSUP (mdf.CD_EMP,mdf.CD_PROD,g.CD_GRP_ECON)	,
				B.QT_EST	QT_EST_LJ,
				B.QT_PEND	QT_PEND_ENT_LJ,
				depo.QT_EST			QT_EST_DEPO_RES,
				mdf.QTDE_FACEAMENTO QT_FACEAMENTO,
				mdf.QTDE_FINANCIADO QT_FINANCIAMENTO,
				mdf.QTDE_LIMITADOR	QT_LIMITADOR,
				arv.ConsideraEseg,
				ISNULL(dbo.UFD_BUSCA_PRECO_PRODUTO (@CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,0,17,a.CD_FIL_DEST),0) VLR_CUSTO_PROD_ORIG,-- Custo filial origem 
				b.SALDO +  Round( ((b.MEDIAF/30.000) * @ParamAddAgd),0) QT_RESSUPRIR
			FROM        
				EST_PROD_TRANSF_GERAL a
				join EST_PROD_TRANSF_GERAL_CPL b on 
				a.cd_ctr = b.cd_Ctr
				INNER JOIN EST_PROD_CPL_MEDIAF mdf ON
				A.CD_EMP		= mdf.CD_EMP AND
				A.CD_FIL_DEST 	= mdf.CD_FILIAL AND 
				B.CD_PROD		= mdf.CD_PROD 
				INNER JOIN EST_PROD_TRANSF_MEDIAF_PARAMS arv ON 
				mdf.CD_EMP		= arv.CD_EMP AND 
				mdf.CD_FILIAL	= arv.CD_FILIAL AND 
				mdf.CD_PROD		= arv.CD_PROD
				INNER JOIN PRC_GRP_ECON_PRC_FILIAL g ON  --Grupo economico da filial de destino
				mdf.CD_EMP		= g.CD_EMP AND 
				mdf.CD_FILIAL	= g.CD_FILIAL   
				INNER JOIN EST_PROD pol ON  --preco ope log
				mdf.CD_EMP	= pol.CD_EMP AND 
				mdf.CD_PROD = pol.CD_PROD 
				LEFT JOIN EST_PROD_CPL depo ON  --para localiza??o dos produtos (prateleira)
				mdf.CD_PROD = depo.CD_PROD AND 
				mdf.CD_EMP	= depo.CD_EMP AND 
				depo.CD_FILIAL = @CD_DEPOSITO
				LEFT JOIN (SELECT  pr.CD_EMP , pr.CD_PRT, ISNULL(pr.CD_GRP_PRT,0) CD_GRP_PRT
							FROM 
								EST_PROD_PRT_GRP_RESSUPRIMENTO GRP 
								join EST_PROD_PRT_GRP_RESSUPRIMENTO_CPL pr  ON GRP.CD_GRP_PRT = PR.CD_GRP_PRT
								WHERE	ISNULL(GRP.CD_CTR_DEPO,@CD_CTR_DEPO) =@CD_CTR_DEPO) pr ON  --localiza??o dos produtos (grupo de prateleiras)
				depo.CD_EMP   = pr.CD_EMP AND 
				depo.PRAT	  = pr.CD_PRT 
				INNER JOIN PRC_FILIAL ON
				a.CD_EMP	  = PRC_FILIAL.CD_EMP AND
				a.CD_FIL_DEST = PRC_FILIAL.CD_FILIAL
			WHERE
				A.DT_TRANSF =@HOJE
				and a.STS_tRANSF=0),
		BASE2 AS (SELECT	
						CD_FILIAL, 
						CD_PROD, 
						EMAX, 
						QMIN=Case When @UtilizarEsegDecimal =1 then ESEG
											else Round(ESEG,0) end, 
						QT_MEDIAF, 
						CD_GRP_RES, 
						QT_EST, 
						CD_SIGLA, 
						ESEGCAD, 
						EMAXCAD, 
						PARAM_ESPECIAL, 
						CD_GRP_PRT, 
						VLR_CUSTO, 
						VLR_CUSTO_MD,
						QT_UNI_RESSUPRIMENTO, 
						FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
						QT_EST_RESSUP_INI = (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 0 THEN --SEM CAIXA FECHADA
													CASE WHEN ROUND( (QT_RESSUPRIR/QT_UNI_RESSUPRIMENTO) ,2)  BETWEEN 0 AND 0.49 THEN 
															ROUND(QT_RESSUPRIR,0)
														ELSE 
															ROUND((ROUND((QT_RESSUPRIR / QT_UNI_RESSUPRIMENTO) ,0)  * QT_UNI_RESSUPRIMENTO),0)
														END
												ELSE --Com caixa fechada
													CASE WHEN (@AJUSTA_DEMANDA_EMB =1 AND ISNULL( (ROUND( (ROUND(QT_RESSUPRIR,0)/ QT_UNI_RESSUPRIMENTO),0)* QT_UNI_RESSUPRIMENTO),0) BETWEEN 0 AND 1) OR 
															  (QT_EST               < 1 AND ISNULL( (ROUND( (ROUND(QT_RESSUPRIR,0)/ QT_UNI_RESSUPRIMENTO),0)* QT_UNI_RESSUPRIMENTO),0) BETWEEN 0 AND 1 )	THEN 
															1 * ISNULL(QT_UNI_RESSUPRIMENTO,1)
														ELSE ISNULL( (ROUND( (ROUND(QT_RESSUPRIR,0)/ QT_UNI_RESSUPRIMENTO),0)* QT_UNI_RESSUPRIMENTO),0) END
												END),
						PERC_DESC,
						QT_EST_LJ,
						QT_PEND_ENT_LJ,
						QT_EST_DEPO_RES,
						QT_FACEAMENTO,
						QT_FINANCIAMENTO,
						QT_LIMITADOR,
						ConsideraEseg,
						VLR_CUSTO_PROD_ORIG
					FROM
						BASE1
					WHERE	
						QT_EST <= EMAX)  
		--no caso de agrupamento de produtos para ressuprimento (QT_UNI_RESSUPRIMENTO>1), digite 
		INSERT INTO EST_PROD_TRANSF_NECESSIDADE_FUTURA (CD_FILIAL, CD_PROD,  EMAX, 												
														QMIN, QTDE_MEDIAF,	CD_GRP_RES, 												
														QTDE_EST, CD_SIGLA, ESEGCAD, 												
														EMAXCAD, PARAM_ESPECIAL, CD_GRP_PRT, 
														VLR_PROD, VLR_CUSTO_MD,QT_UNI_RESSUPRIMENTO, FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
														QT_EST_RESSUP_INI,QT_EST_RESSUP_ORIG,  QT_EST_RESSUP, PERC_DESC,
														QT_EST_LJ,QT_PEND_ENT_LJ,POSICAO,SUB_TOTAL,QT_EST_DEPO_RES,
														QT_FACEAMENTO,QT_FINANCIAMENTO,QT_LIMITADOR,ConsideraEseg, VLR_CUSTO_PROD_ORIG)
		SELECT	
			CD_FILIAL, 
			CD_PROD, 
			EMAX, 			
			QMIN, 
			QT_MEDIAF, 
			CD_GRP_RES, 			
			QT_EST, 
			CD_SIGLA, 
			ESEGCAD, 			
			EMAXCAD, 
			PARAM_ESPECIAL, 
			CD_GRP_PRT, 			
			case when VLR_CUSTO < 0 then 0 
				else VLR_CUSTO end VLR_CUSTO , 
			VLR_CUSTO_MD,
			QT_UNI_RESSUPRIMENTO, 
			FLAG_RESSUPRIMENTO_CAIXA_FECHADA,			
			QT_EST_RESSUP_INI, 
			QT_EST_RESSUP_INI,  
			QT_EST_RESSUP_INI,
			PERC_DESC,			
			QT_EST_LJ, 
			QT_PEND_ENT_LJ, 
			ROW_NUMBER() OVER (PARTITION BY CD_GRP_PRT   ORDER BY  CD_GRP_PRT, CONVERT(MONEY, (QT_EST_LJ + QT_PEND_ENT_LJ/ 
																CASE WHEN QT_MEDIAF > 0 THEN QT_MEDIAF ELSE 0.001 END  ) *30.000) ) POSICAO,
			0 SUBTOT,
			QT_EST_DEPO_RES,
			QT_FACEAMENTO,
			QT_FINANCIAMENTO,
			QT_LIMITADOR,
			ConsideraEseg,
			VLR_CUSTO_PROD_ORIG
		FROM BASE2
		WHERE 
			QT_EST <EMAX
			AND EMAX > 0
			AND QT_EST_RESSUP_INI>0;
			
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
				, 'Inicio dos registro de necessidade de ressuprimento '
				,'INSERT'
				, 1623
				,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
				,'EST_PROD_TRANSF_NECESSIDADE_FUTURA'
				,'RESSUPRIMENTO');

	end
else
	begin
	;WITH BASE1 AS (
			SELECT     
				E.CD_FILIAL, 
				E.CD_PROD, 
				EMAX = dbo.UFD_EST_AJUSTA_EMAX(round(mdf.QTDE_FACEAMENTO * @PERC_FACE,0) , mdf.VALID_QTDE_FACEAMENTO, 
												round(mdf.QTDE_FINANCIADO * @PERC_FACE,0) , round(mdf.QTDE_LIMITADOR * @PERC_FACE,0), 
												CASE WHEN mdf.QTDE_MEDIAF > 0 THEN 
													ROUND(mdf.QTDE_MEDIAF/30 * arv.EMAX, 2)
												ELSE 
													ROUND(mdp.QTDE_MEDIAP/30 * arv.EMAX, 2) 
												END),
				ESEG = dbo.UFD_EST_AJUSTA_ESEG(CASE WHEN ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)=0 THEN
													round(mdf.QTDE_FACEAMENTO * @PERC_FACE,0)
												ELSE
													ROUND(MDF.QTDE_FACEAMENTO  * (ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)/100.00),0)
												END, 
												mdf.VALID_QTDE_FACEAMENTO, 
												round(mdf.QTDE_FINANCIADO * @PERC_FACE,0) , 
												CASE WHEN mdf.QTDE_MEDIAF > 0 THEN 
													ROUND(mdf.QTDE_MEDIAF/30 * arv.ESEG, 2)
												ELSE 
													ROUND(mdp.QTDE_MEDIAP/30 * arv.ESEG, 2) 
												END),
				QT_EST		= CASE WHEN E.QT_EST_PEND > 0 THEN E.QT_EST_PEND ELSE 0 END,	
				QT_MEDIAF	= CASE WHEN isnull(mdf.QTDE_MEDIAF,0) > 0 THEN mdf.QTDE_MEDIAF ELSE mdp.QTDE_MEDIAP END,
				arv.CD_GRP_RES,
				mdf.CD_SIGLA,
				arv.PARAM_ESPECIAL,
				ESEGCAD		= arv.ESEG,
				EMAXCAD		= arv.EMAX,
				CD_GRP_PRT	= ISNULL(pr.CD_GRP_PRT,0),   --localizacao dos produtos (grupo de prateleiras)
				VLR_CUSTO = CASE WHEN @TP_PRECO <> 9 THEN -- Se for preco parametrizado
								dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD, @TP_PRECO,2,E.CD_FILIAL) -- Preco parametrizado
							ELSE -- Se nao for preco parametrizado
								CASE WHEN ISNULL(FLAG_FILIAL_FRANQUIA,0) = 0 THEN
									CASE WHEN @CD_DEPO_OPERADOR = 1 THEN
										CASE WHEN dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,8,2,E.CD_FILIAL) =0 THEN
												dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,14,2,E.CD_FILIAL) --Ressuprimento
											ELSE 
												dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,8,2,E.CD_FILIAL) 
											END  --Preco Operador Log	 
									ELSE
										dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD, @TP_PRECO,2,E.CD_FILIAL) -- Preco parametrizado
									END
								ELSE
									dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,13,2,E.CD_FILIAL) --Preco Franquia	 
								END
							END,
				ISNULL(dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,0,2,E.CD_FILIAL),0) VLR_CUSTO_MD,-- Custo Medio para auditorias posteriores 
				arv.QT_UNI_RESSUPRIMENTO,
				arv.FLAG_RESSUPRIMENTO_CAIXA_FECHADA,			
				PERC_DESC = dbo.UFD_EST_PROD_DESCONTO_RESSUP (mdf.CD_EMP,mdf.CD_PROD,g.CD_GRP_ECON)	,
				E.QT_EST QT_EST_LJ,
				E.QT_PEND_ENT QT_PEND_ENT_LJ,
				depo.QT_EST			QT_EST_DEPO_RES,
				mdf.QTDE_FACEAMENTO QT_FACEAMENTO,
				mdf.QTDE_FINANCIADO QT_FINANCIAMENTO,
				mdf.QTDE_LIMITADOR	QT_LIMITADOR,
				arv.ConsideraEseg,
				ISNULL(dbo.UFD_BUSCA_PRECO_PRODUTO (mdf.CD_EMP,@CD_DEPOSITO,mdf.CD_PROD,0,17,E.CD_FILIAL),0) VLR_CUSTO_PROD_ORIG-- Custo filial origem 
			FROM         
				V_EST_PROD_CPL_ESTOQUE E
				INNER JOIN EST_PROD_CPL_MEDIAF mdf ON
				E.CD_EMP		= mdf.CD_EMP AND
				E.CD_FILIAL		= mdf.CD_FILIAL AND 
				E.CD_PROD		= mdf.CD_PROD 
				--Filiais do mesmo deposito
				--INNER JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL lj ON
				--E.CD_EMP		= lj.CD_EMP AND
				--E.CD_FILIAL		= lj.CD_FILIAL
				--AND lj.CD_CTR_DEPO =@CD_CTR_DEPO
				INNER JOIN EST_PROD_TRANSF_MEDIAF_PARAMS arv ON 
				mdf.CD_EMP		= arv.CD_EMP AND 
				mdf.CD_FILIAL	= arv.CD_FILIAL AND 
				mdf.CD_PROD		= arv.CD_PROD
				INNER JOIN PRC_GRP_ECON_PRC_FILIAL g ON  --Grupo economico da filial de destino
				mdf.CD_EMP		= g.CD_EMP AND 
				mdf.CD_FILIAL	= g.CD_FILIAL   
				INNER JOIN EST_PROD pol ON  --preco ope log
				mdf.CD_EMP	= pol.CD_EMP AND 
				mdf.CD_PROD = pol.CD_PROD 
				LEFT OUTER JOIN EST_PROD_CPL_MEDIAP mdp ON --Media prevista para produtos menores de 90 dias de nascimento na filial
				mdf.CD_EMP		= mdp.CD_EMP AND 
				mdf.CD_FILIAL	= mdp.CD_FILIAL AND 
				mdf.CD_PROD		= mdp.CD_PROD 	
				LEFT JOIN EST_PROD_CPL depo ON  --para localiza??o dos produtos (prateleira)
				mdf.CD_PROD = depo.CD_PROD AND 
				mdf.CD_EMP	= depo.CD_EMP AND 
				depo.CD_FILIAL = @CD_DEPOSITO
				LEFT JOIN (SELECT  pr.CD_EMP , pr.CD_PRT, ISNULL(pr.CD_GRP_PRT,0) CD_GRP_PRT
							FROM 
								EST_PROD_PRT_GRP_RESSUPRIMENTO GRP 
								join EST_PROD_PRT_GRP_RESSUPRIMENTO_CPL pr  ON GRP.CD_GRP_PRT = PR.CD_GRP_PRT
								WHERE	ISNULL(GRP.CD_CTR_DEPO,@CD_CTR_DEPO) =@CD_CTR_DEPO) pr ON  --localiza??o dos produtos (grupo de prateleiras)
				depo.CD_EMP   = pr.CD_EMP AND 
				depo.PRAT	  = pr.CD_PRT 
				INNER JOIN PRC_FILIAL ON
				E.CD_EMP = PRC_FILIAL.CD_EMP AND
				E.CD_FILIAL = PRC_FILIAL.CD_FILIAL),
		BASE2 AS (SELECT	
						CD_FILIAL, 
						CD_PROD, 
						EMAX, 
						QMIN=Case When @UtilizarEsegDecimal =1 then ESEG
											else Round(ESEG,0) end, 
						QT_MEDIAF, 
						CD_GRP_RES, 
						QT_EST, 
						CD_SIGLA, 
						ESEGCAD, 
						EMAXCAD, 
						PARAM_ESPECIAL, 
						CD_GRP_PRT, 
						VLR_CUSTO, 
						VLR_CUSTO_MD,
						QT_UNI_RESSUPRIMENTO, 
						FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
						QT_EST_RESSUP_INI = (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 0 THEN --SEM CAIXA FECHADA
											CASE WHEN (EMAX - QT_EST) >= QT_UNI_RESSUPRIMENTO THEN
												CASE WHEN ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 2) - FLOOR(ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 2)) BETWEEN 0 AND @PERC_AUMENTO THEN
													ROUND((ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 0) * QT_UNI_RESSUPRIMENTO), 0)				
												ELSE
													CEILING((CEILING(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO)) * QT_UNI_RESSUPRIMENTO))
												END
											ELSE
												CASE WHEN ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 2) - FLOOR(ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 2)) BETWEEN 0 AND @PERC_AUMENTO THEN
													ROUND((EMAX - QT_EST), 0)
												ELSE
													CEILING(CEILING((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO) * QT_UNI_RESSUPRIMENTO)
												END
											END
										ELSE --Com caixa fechada
											 --(@AJUSTA_DEMANDA_EMB = 1 Quer dizer que mesmo que nao tenha demanda sufiente para uma caixa , manda uma caixa.)
											/*CASE WHEN (@AJUSTA_DEMANDA_EMB = 1 AND ISNULL((ROUND((ROUND(EMAX - QT_EST,0) / QT_UNI_RESSUPRIMENTO), 0) * QT_UNI_RESSUPRIMENTO), 0) BETWEEN 0 AND 1) OR 
													  (QT_EST             < 1 AND ISNULL((ROUND((ROUND(EMAX - QT_EST,0) / QT_UNI_RESSUPRIMENTO), 0) * QT_UNI_RESSUPRIMENTO), 0) BETWEEN 0 AND 1 )	THEN 
													  */
											CASE WHEN (@AJUSTA_DEMANDA_EMB = 1 AND EMAX > 0 AND ISNULL((ROUND((ROUND(EMAX - QT_EST,2)/QT_UNI_RESSUPRIMENTO), 2)), 0) BETWEEN 0 AND 1) OR 
													  (QT_EST             < 1 AND ISNULL((ROUND((ROUND(EMAX - QT_EST,0) / QT_UNI_RESSUPRIMENTO), 0) * QT_UNI_RESSUPRIMENTO), 0) BETWEEN 0 AND 1 )	THEN  												
												1 * ISNULL(QT_UNI_RESSUPRIMENTO,1)
											ELSE
												CASE WHEN (EMAX - QT_EST) >= QT_UNI_RESSUPRIMENTO THEN
													CASE WHEN ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 2) - FLOOR(ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 2)) BETWEEN 0 AND @PERC_AUMENTO THEN
														ROUND((ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 0) * QT_UNI_RESSUPRIMENTO), 0)				
													ELSE
														CEILING((CEILING(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO)) * QT_UNI_RESSUPRIMENTO))
													END
												ELSE
													CASE WHEN ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 2) - FLOOR(ROUND(((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO), 2)) BETWEEN 0 AND @PERC_AUMENTO THEN
														0
													ELSE
														CEILING(CEILING((EMAX - QT_EST) / QT_UNI_RESSUPRIMENTO) * QT_UNI_RESSUPRIMENTO)
													END
												END
											END
										END),
						PERC_DESC,
						QT_EST_LJ,
						QT_PEND_ENT_LJ,
						QT_EST_DEPO_RES,
						QT_FACEAMENTO,
						QT_FINANCIAMENTO,
						QT_LIMITADOR,
						ConsideraEseg,
						VLR_CUSTO_PROD_ORIG
					FROM
						BASE1
					WHERE	
						QT_EST <= EMAX) 
				--		QT_EST <= ESEG) --quantidade em estoque menor que o estoque de seguran?a
		--no caso de agrupamento de produtos para ressuprimento (QT_UNI_RESSUPRIMENTO>1), digite 
		INSERT INTO EST_PROD_TRANSF_NECESSIDADE_FUTURA (CD_FILIAL, CD_PROD,  EMAX, 												
														QMIN, QTDE_MEDIAF,	CD_GRP_RES, 												
														QTDE_EST, CD_SIGLA, ESEGCAD, 												
														EMAXCAD, PARAM_ESPECIAL, CD_GRP_PRT, 
														VLR_PROD, VLR_CUSTO_MD,QT_UNI_RESSUPRIMENTO, FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
														QT_EST_RESSUP_INI,QT_EST_RESSUP_ORIG,  QT_EST_RESSUP, PERC_DESC,
														QT_EST_LJ,QT_PEND_ENT_LJ,POSICAO,SUB_TOTAL,QT_EST_DEPO_RES,
														QT_FACEAMENTO,QT_FINANCIAMENTO,QT_LIMITADOR,ConsideraEseg, VLR_CUSTO_PROD_ORIG)
		SELECT	
			CD_FILIAL, 
			CD_PROD, 
			EMAX, 			
			QMIN, 
			QT_MEDIAF, 
			CD_GRP_RES, 			
			QT_EST, 
			CD_SIGLA, 
			ESEGCAD, 			
			EMAXCAD, 
			PARAM_ESPECIAL, 
			CD_GRP_PRT, 			
			case when VLR_CUSTO < 0 then 0 
				else VLR_CUSTO end VLR_CUSTO , 
			VLR_CUSTO_MD,
			QT_UNI_RESSUPRIMENTO, 
			FLAG_RESSUPRIMENTO_CAIXA_FECHADA,			
			QT_EST_RESSUP_INI, 
			QT_EST_RESSUP_INI,  
			QT_EST_RESSUP_INI,
			PERC_DESC,			
			QT_EST_LJ, 
			QT_PEND_ENT_LJ, 
			ROW_NUMBER() OVER (PARTITION BY CD_GRP_PRT   ORDER BY  CD_GRP_PRT, CONVERT(MONEY, (QT_EST_LJ + QT_PEND_ENT_LJ/ 
																CASE WHEN QT_MEDIAF > 0 THEN QT_MEDIAF ELSE 0.001 END  ) *30.000) ) POSICAO,
			0 SUBTOT,
			QT_EST_DEPO_RES,
			QT_FACEAMENTO,
			QT_FINANCIAMENTO,
			QT_LIMITADOR,
			ConsideraEseg,
			VLR_CUSTO_PROD_ORIG
		FROM BASE2
		WHERE 
			QT_EST <EMAX
			AND EMAX > 0
			AND QT_EST_RESSUP_INI>0; 

		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			, 'Inicio dos registro de necessidade de ressuprimento '
			,'INSERT'
			, 1623
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_NECESSIDADE_FUTURA'
			,'RESSUPRIMENTO');
	end
---------------------------------------------------------------------------------------------------------------------------------------

	-- Ajuste de eestoque deposito para caixas fechadas. 
	 UPDATE EST_PROD_TRANSF_NECESSIDADE_FUTURA 
	    SET QT_EST_DEPO_RES = ROUND(( QT_EST_DEPO_RES / QT_UNI_RESSUPRIMENTO),0)*QT_UNI_RESSUPRIMENTO
	  WHERE FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 
        AND QT_UNI_RESSUPRIMENTO > 0 
	    AND ROUND(( QT_EST_DEPO_RES / QT_UNI_RESSUPRIMENTO),0)*QT_UNI_RESSUPRIMENTO  <> QT_EST_DEPO_RES
	--no caso de agrupamento de produtos para ressuprimento (QT_UNI_RESSUPRIMENTO>1), digite 
	INSERT INTO EST_PROD_TRANSF_NECESSIDADE  (CD_FILIAL, CD_PROD,  EMAX, 												
													QMIN, QTDE_MEDIAF,	CD_GRP_RES, 												
													QTDE_EST, CD_SIGLA, ESEGCAD, 												
													EMAXCAD, PARAM_ESPECIAL, CD_GRP_PRT, 
													VLR_PROD, VLR_CUSTO_MD,QT_UNI_RESSUPRIMENTO, FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
													QT_EST_RESSUP_INI,QT_EST_RESSUP_ORIG,  QT_EST_RESSUP, PERC_DESC,
													QT_EST_LJ,QT_PEND_ENT_LJ,QT_EST_DEPO_RES,QT_FACEAMENTO,QT_FINANCIAMENTO,QT_LIMITADOR,ALIQ_ICMS_ENTRADA, VLR_CUSTO_PROD_ORIG)
	SELECT	
		N.CD_FILIAL, 
		N.CD_PROD, 
		N.EMAX, 								
		N.QMIN, 
		N.QTDE_MEDIAF,	
		N.CD_GRP_RES, 							
		N.QTDE_EST, 
		N.CD_SIGLA, 
		N.ESEGCAD, 								
		N.EMAXCAD, 
		N.PARAM_ESPECIAL, 
		N.CD_GRP_PRT,							
		N.VLR_PROD, 
		N.VLR_CUSTO_MD,
		N.QT_UNI_RESSUPRIMENTO, 
		N.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 	
		N.QT_EST_RESSUP_INI,
		N.QT_EST_RESSUP_ORIG,  
		N.QT_EST_RESSUP, 
		N.PERC_DESC,							
		N.QT_EST_LJ,
		N.QT_PEND_ENT_LJ,
		N.QT_EST_DEPO_RES ,
		N.QT_FACEAMENTO,	
		N.QT_FINANCIAMENTO,
		N.QT_LIMITADOR,
		alq.ALIQ_ICMS_ENTRADA,
		n.VLR_CUSTO_PROD_ORIG
	FROM 
		EST_PROD_TRANSF_NECESSIDADE_FUTURA N
		LEFT JOIN (SELECT   
					b.CD_FILIAL
					,a.CD_PROD
					,ISNULL(a.ALIQ_ICMS_ENTRADA,0) ALIQ_ICMS_ENTRADA
				FROM  
					GLB_CONFIG_PRECO_RESSUP_EST_PROD a 
					join GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL b on 
					a.CD_EMP    =b.CD_EMP and 
					a.CD_CONFIG =b.CD_CONFIG) Alq ON 
		N.CD_PROD	= Alq.CD_PROD  and 
		N.CD_FILIAL	= Alq.CD_FILIAL
	WHERE 
		case when ConsideraEseg =1 then QTDE_EST 
			else QMIN end <= QMIN
		AND EMAX > 0;


	IF @consulta%2=1 AND @CD_PROD IS NOT NULL  --DEBUG
	  begin
		SELECT 'TMP_COMPRA_POR_SUPRIMENTO', * FROM #TMP_COMPRA_POR_SUPRIMENTO
		Select 
				@CD_DEPOSITO  CD_DEPOSITO 
				,@PERC_FACE				PERC_FACE
				,@CD_CTR_DEPO		    CD_CTR_DEPO
				,@UtilizarEsegDecimal   UtilizarEsegDecimal
				,@PERC_AUMENTO		    PERC_AUMENTO 
				,@TP_PRECO				TP_PRECO
				,@AJUSTA_DEMANDA_EMB	AJUSTA_DEMANDA_EMB 
				,@CD_DEPO_OPERADOR		CD_DEPO_OPERADOR 
				,@DEPO_AUX_DISTRIBUIDOR DEPO_AUX_DISTRIBUIDOR
		SELECT * FROM EST_PROD_TRANSF_NECESSIDADE_FUTURA
	  END 
	DELETE FROM EST_PROD_TRANSF_NECESSIDADE_FUTURA
	WHERE 
		case when ConsideraEseg =1 then QTDE_EST 
			else QMIN end <= QMIN
		AND EMAX > 0;
IF NOT EXISTS(SELECT TOP  1 CD_PROD FROM EST_PROD_TRANSF_NECESSIDADE)
	GOTO SemNecessidade
PRINT 'Registro de produtos e filiais com necessidade de ressuprimento ' + CONVERT(VARCHAR, GETDATE(), 108);
/**********************************************************************************************************/
/**********************************************************************************************************/
IF @consulta%2=1 AND @CD_PROD IS NOT NULL  --DEBUG
  begin
	PRINT 'Registro inicial de necessidade de ressuprimento - EST_PROD_TRANSF_NECESSIDADE';
	SELECT CD_FILIAL, 
			CD_PROD, 
			EMAX, 
			QMIN, 
			QTDE_MEDIAF,	
			CD_GRP_RES, 
			QTDE_EST, 
			CD_SIGLA, 
			ESEGCAD, 
			EMAXCAD, 
			PARAM_ESPECIAL, 
			CD_GRP_PRT, 
			VLR_PROD, 
			QT_UNI_RESSUPRIMENTO, 
			FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
			QT_EST_RESSUP_INI, 
			QT_EST_RESSUP, 
			PERC_DESC,
			QT_EST_LJ,
			QT_PEND_ENT_LJ FROM EST_PROD_TRANSF_NECESSIDADE; --DEBUG
  end
 ELSE 
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Calculada necessidade de ressuprimento preliminar'
			,'INFROMACAO'
			, 1976
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_NECESSIDADE'
			,'RESSUPRIMENTO');


--registra valores comuns para todas as filiais (somas entre filiais e valores do deposito)
	WITH FILIAIS AS (SELECT	
						CD_PROD,
						QT_UNI_RESSUPRIMENTO,
						FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
						QT_EST_FILIAIS_SOMA		= SUM(QTDE_EST),
						QT_MEDIAF_SOMA			= SUM(QTDE_MEDIAF),
						QT_RESSUP_SOMA			= SUM(ROUND(QT_EST_RESSUP, 0)),
						QT_NECESSIDADE_FILIAIS	= SUM(case when FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1 then
																ROUND((QT_EST_RESSUP/QT_UNI_RESSUPRIMENTO),0)*QT_UNI_RESSUPRIMENTO
														else QT_EST_RESSUP end),
						PERC_DESC = AVG(PERC_DESC)
					FROM 
						EST_PROD_TRANSF_NECESSIDADE
					GROUP BY 
						CD_PROD, 
						QT_UNI_RESSUPRIMENTO,
						FLAG_RESSUPRIMENTO_CAIXA_FECHADA),
		DEPOSITO AS (SELECT
							CD_PROD,
							SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) AS QT_DEPOSITO_INICIO
						FROM
							V_EST_PROD_CPL_ESTOQUE
						WHERE	
							CD_EMP=@CD_EMP 
							AND CD_FILIAL=@CD_DEPOSITO 
						GROUP BY
							CD_PROD
						HAVING SUM((QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI) > 0 )
	INSERT INTO EST_PROD_TRANSF_CONSOLIDADO(CD_PROD, QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
											QT_EST_FILIAIS_SOMA, QT_MEDIAF_SOMA, QT_RESSUP_SOMA, QT_NECESSIDADE_FILIAIS, 
											QT_DEPOSITO_INICIO, QT_DEPOSITO, PERC_DESC)
	SELECT	
		f.CD_PROD, 
		f.QT_UNI_RESSUPRIMENTO, 
		f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
		f.QT_EST_FILIAIS_SOMA, 
		f.QT_MEDIAF_SOMA, 
		f.QT_RESSUP_SOMA, 
		f.QT_NECESSIDADE_FILIAIS, 
		CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN
			--d.QT_DEPOSITO_INICIO - (convert(money, d.QT_DEPOSITO_INICIO)%f.QT_UNI_RESSUPRIMENTO)
			ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
		ELSE d.QT_DEPOSITO_INICIO END QT_DEPOSITO_INICIO, 
		QT_DEPOSITO = (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN
							--d.QT_DEPOSITO_INICIO - (convert(money, d.QT_DEPOSITO_INICIO)%f.QT_UNI_RESSUPRIMENTO)
							ROUND((d.QT_DEPOSITO_INICIO/f.QT_UNI_RESSUPRIMENTO),0)* f.QT_UNI_RESSUPRIMENTO  
						ELSE d.QT_DEPOSITO_INICIO END), 
		f.PERC_DESC
		--deposito ? divido por grupos de ressuprimento, deposito_inicio nao
	FROM 
		FILIAIS f 
		JOIN DEPOSITO d ON 
		d.CD_PROD=f.CD_PROD;
IF @@ROWCOUNT = 0 GOTO SemRateio

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Registra valores comuns para todas as filiais'
			,'INFORMACAO'
			, 2042
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_CONSOLIDADO'
			,'RESSUPRIMENTO');


PRINT 'Registra valores comuns para todas as filiais ' + CONVERT(VARCHAR, GETDATE(), 108) ;
IF @consulta%2=1 AND @CD_PROD IS NOT NULL  --DEBUG
  begin
	PRINT 'Registro de somas entre filiais e valores do deposito - EST_PROD_TRANSF_CONSOLIDADO';
	SELECT * FROM EST_PROD_TRANSF_CONSOLIDADO; --DEBUG
  end
 ELSE 
	PRINT 'Calculada consolidacao dos estoques (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';
/**********************************************************************************************************/
/* 
--============================ AJUSTES DOS PEDIDOS (RATEIO DE PICKING) ==========================--
	Calculo inicial quantidade para pedido, com o rateio, cujo parametro principal e o Percentual de rateio.
	Ele e a razao entre a quantidade disponivel em estoque e a necessidade de todas lojas, para um dado produto. 
	Esse percentual, multiplicado pela necessidade de uma filial, retorna a quantidade com a qual a loja sera atendida.
	Exemplos:
	 - 100%: ha a possibilidade de atender todas as necessidades, nao ha rateio. 
	 -  50%: cada filial recebe metade do que necessita
	O retorno de com qual quantidade sera atendida cada filial, E registrado na tabela de Pedidos.
*/
/**********************************************************************************************************/
 	WITH BASE1 AS (SELECT	
						f.CD_FILIAL, 
						f.CD_PROD, 
						f.QTDE_MEDIAF, 
						f.QTDE_EST, 
						f.QT_EST_RESSUP,
						EMAX_INT=ROUND(f.EMAX,0), 
						QT_NECESSIDADE=  CASE WHEN s.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN
											ROUND(((QT_EST_RESSUP)/convert(money,s.QT_UNI_RESSUPRIMENTO)) ,0) * s.QT_UNI_RESSUPRIMENTO
										ELSE  QT_EST_RESSUP  END,  
						PERC_RATEIO=s.QT_DEPOSITO /s.QT_NECESSIDADE_FILIAIS,			
						s.QT_MEDIAF_SOMA, 
						s.QT_DEPOSITO, 
						s.QT_EST_FILIAIS_SOMA,
						s.QT_UNI_RESSUPRIMENTO,
						s.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
					FROM 
						EST_PROD_TRANSF_NECESSIDADE f 
						INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
						f.CD_PROD=s.CD_PROD
					WHERE 
						s.QT_NECESSIDADE_FILIAIS > s.QT_DEPOSITO 
						),
		BASE2 AS (SELECT	
						CD_FILIAL, 
						CD_PROD, 
						EMAX_INT,  
						QT_NECESSIDADE= CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN
											ROUND(((QT_NECESSIDADE)/convert(money,QT_UNI_RESSUPRIMENTO)) ,0) * QT_UNI_RESSUPRIMENTO
										ELSE  QT_NECESSIDADE  END,  
						QT_PED1= CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN
											CASE WHEN (@AJUSTA_DEMANDA_EMB =1 AND (ROUND(((QT_EST_RESSUP * PERC_RATEIO)/QT_UNI_RESSUPRIMENTO) ,0) * QT_UNI_RESSUPRIMENTO) BETWEEN 0 AND 1) OR 
													  (QTDE_EST            <1 AND (ROUND(((QT_EST_RESSUP * PERC_RATEIO)/QT_UNI_RESSUPRIMENTO) ,0) * QT_UNI_RESSUPRIMENTO) BETWEEN 0 AND 1 ) THEN
												(1 * ISNULL(QT_UNI_RESSUPRIMENTO,1))
											 ELSE  (ROUND(((QT_EST_RESSUP * PERC_RATEIO)/QT_UNI_RESSUPRIMENTO) ,0) * QT_UNI_RESSUPRIMENTO) END
										ELSE  (QT_EST_RESSUP * PERC_RATEIO) END, 
						PERC_RATEIO, 
						QT_MEDIAF_SOMA, 
						QT_DEPOSITO, 
						QT_EST_FILIAIS_SOMA ,
						QTDE_EST, 
						QT_UNI_RESSUPRIMENTO,
						FLAG_RESSUPRIMENTO_CAIXA_FECHADA
					FROM 
						BASE1) 
	INSERT INTO EST_PROD_TRANSF_PEDIDO (CD_FILIAL, CD_PROD, QT_PED, PERC_RATEIO, MEDIAF_SOMA, QTDE_DEPOS_SOMA, QTDE_FILIAIS_SOMA)
	SELECT	
		CD_FILIAL, 
		CD_PROD, 
		QT_PED= CASE WHEN QT_PED1 < QT_NECESSIDADE THEN 
								QT_PED1 
					ELSE QT_NECESSIDADE END ,				
		PERC_RATEIO, 
		QT_MEDIAF_SOMA, 
		QT_DEPOSITO, 
		QT_EST_FILIAIS_SOMA
	FROM BASE2;

	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Grava na tabela de EST_PROD_TRANSF_PEDIDO ' 
			,'INSERT'
			, 2131
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_PEDIDO'
			,'RESSUPRIMENTO');

	
IF @consulta%2=1 AND @CD_PROD IS NOT NULL  --DEBUG
  BEGIN
	PRINT 'Registro inicial de pedido, com o rateio - EST_PROD_TRANSF_PEDIDO';
	SELECT * FROM EST_PROD_TRANSF_PEDIDO; --DEBUG 
  END
ELSE 
	PRINT 'Realizado rateio preliminar (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';
--gerando exclusoes (combinacoes de filiais e produtos cuja quantidade do pedido ficou negativa)
DECLARE @pedidoExcluido TABLE (		CD_FILIAL	INT,
									CD_PROD		INT,
									PRIMARY KEY (CD_PROD, CD_FILIAL));
	INSERT INTO @pedidoExcluido (CD_FILIAL, CD_PROD)
	SELECT 
		CD_FILIAL, 
		CD_PROD 
	FROM 
		EST_PROD_TRANSF_PEDIDO 
	WHERE QT_PED <=0; 
--retirando filial x produto com quantidade para pedido negativa
WHILE EXISTS (SELECT * FROM @pedidoExcluido)
	begin

		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Rateio - retirando filial x produto com quantidade para pedido negativa ' 
			,'INSERT'
			, 2131
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_PEDIDO'
			,'RESSUPRIMENTO');

		DELETE n FROM EST_PROD_TRANSF_NECESSIDADE n --exclui da base
		WHERE EXISTS (SELECT * FROM @pedidoExcluido WHERE CD_PROD=n.CD_PROD AND CD_FILIAL=n.CD_FILIAL);
		DELETE FROM EST_PROD_TRANSF_CONSOLIDADO WHERE CD_PROD IN (SELECT CD_PROD FROM @pedidoExcluido); --recalcula a soma
		--registra valores comuns para todas as filiais (somas entre filiais e valores do deposito)
		WITH FILIAIS AS (SELECT	
							CD_PROD,
							QT_UNI_RESSUPRIMENTO,
							FLAG_RESSUPRIMENTO_CAIXA_FECHADA,
							QT_EST_FILIAIS_SOMA = SUM(QTDE_EST),
							QT_MEDIAF_SOMA = SUM(QTDE_MEDIAF),
							QT_RESSUP_SOMA = SUM(ROUND(QT_EST_RESSUP, 0)),
							QT_NECESSIDADE_FILIAIS = SUM(QT_EST_RESSUP),
							PERC_DESC = AVG(PERC_DESC)
						FROM
							EST_PROD_TRANSF_NECESSIDADE
						GROUP BY 
							CD_PROD, 
							QT_UNI_RESSUPRIMENTO,
							FLAG_RESSUPRIMENTO_CAIXA_FECHADA),
		DEPOSITO AS (SELECT
							CD_PROD, 
							SUM((QT_EST + QT_EST_EM_TERC)- QT_PEND_SAI) AS QT_DEPOSITO_INICIO
						FROM
							V_EST_PROD_CPL_ESTOQUE 
						WHERE	
							CD_EMP=@CD_EMP 
							AND CD_FILIAL=@CD_DEPOSITO 
							AND CD_PROD IN (SELECT CD_PROD FROM @pedidoExcluido)
						GROUP BY
							CD_PROD)
		INSERT INTO EST_PROD_TRANSF_CONSOLIDADO (CD_PROD, QT_UNI_RESSUPRIMENTO,FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
													QT_EST_FILIAIS_SOMA, QT_MEDIAF_SOMA, QT_RESSUP_SOMA, 
													QT_NECESSIDADE_FILIAIS, QT_DEPOSITO_INICIO, QT_DEPOSITO, PERC_DESC)
		SELECT	
			f.CD_PROD, 
			f.QT_UNI_RESSUPRIMENTO, 
			f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA, 
			f.QT_EST_FILIAIS_SOMA, 
			f.QT_MEDIAF_SOMA, 
			f.QT_RESSUP_SOMA, 
			f.QT_NECESSIDADE_FILIAIS,
			CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN
					d.QT_DEPOSITO_INICIO - (convert(money, d.QT_DEPOSITO_INICIO)%f.QT_UNI_RESSUPRIMENTO)
			ELSE d.QT_DEPOSITO_INICIO END QT_DEPOSITO_INICIO, 
			QT_DEPOSITO = (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN
					d.QT_DEPOSITO_INICIO - (convert(money, d.QT_DEPOSITO_INICIO)%f.QT_UNI_RESSUPRIMENTO)
				ELSE d.QT_DEPOSITO_INICIO END), 
			PERC_DESC
		--deposito e divido por grupos de ressuprimento, deposito_inicio nao
		FROM
			FILIAIS f 
			JOIN DEPOSITO d ON 
			d.CD_PROD=f.CD_PROD;

	DELETE EST_PROD_TRANSF_PEDIDO 
	WHERE CD_PROD IN (SELECT CD_PROD FROM @pedidoExcluido); --exclui todas filiais para recalcular
	WITH BASE1 AS (SELECT	
					f.CD_FILIAL, 
					f.CD_PROD, 
					f.QTDE_MEDIAF, 
					f.QTDE_EST, 
					QT_EST_RESSUP =  CASE WHEN S.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN	
										ROUND( (F.QT_EST_RESSUP /s.QT_UNI_RESSUPRIMENTO),0) *  s.QT_UNI_RESSUPRIMENTO
									ELSE  F.QT_EST_RESSUP END,
					EMAX_INT=ROUND(f.EMAX,0), 
					QT_NECESSIDADE= CASE WHEN S.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN	
										ROUND( (F.QT_EST_RESSUP /s.QT_UNI_RESSUPRIMENTO),0) *  s.QT_UNI_RESSUPRIMENTO
									ELSE  F.QT_EST_RESSUP END ,  
					PERC_RATEIO=s.QT_DEPOSITO /s.QT_NECESSIDADE_FILIAIS,			
					s.QT_MEDIAF_SOMA, 
					s.QT_DEPOSITO, 
					s.QT_EST_FILIAIS_SOMA,
					s.QT_UNI_RESSUPRIMENTO,
					s.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
				FROM 
					EST_PROD_TRANSF_NECESSIDADE f 
					INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
					f.CD_PROD=s.CD_PROD
				WHERE 
					s.QT_NECESSIDADE_FILIAIS > s.QT_DEPOSITO 
					AND f.CD_PROD IN (SELECT CD_PROD FROM @pedidoExcluido)),
		BASE2 AS (SELECT	
						CD_FILIAL, 
						CD_PROD, 
						EMAX_INT, 
						QT_NECESSIDADE, 
						QT_PED1=CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA = 1 THEN
											ROUND(((QT_EST_RESSUP * PERC_RATEIO)/QT_UNI_RESSUPRIMENTO) ,0) * QT_UNI_RESSUPRIMENTO
										ELSE  ROUND(QT_EST_RESSUP * PERC_RATEIO,0) END, 
						PERC_RATEIO, 
						QT_MEDIAF_SOMA, 
						QT_DEPOSITO, 
						QT_EST_FILIAIS_SOMA,
						QTDE_EST
					FROM 
						BASE1)     
		INSERT INTO EST_PROD_TRANSF_PEDIDO (CD_FILIAL, CD_PROD, QT_PED, PERC_RATEIO,
										 MEDIAF_SOMA, QTDE_DEPOS_SOMA, QTDE_FILIAIS_SOMA)
		SELECT	
			CD_FILIAL, 
			CD_PROD, 
			QT_PED= CASE WHEN QT_PED1 < QT_NECESSIDADE THEN 
							QT_PED1 ELSE QT_NECESSIDADE END,				
			PERC_RATEIO, 
			QT_MEDIAF_SOMA, 
			QT_DEPOSITO,
			QT_EST_FILIAIS_SOMA
		FROM BASE2;
		DELETE FROM @pedidoExcluido;  --verifica novamente filial x produto com quantidade para pedido negativa
		INSERT INTO @pedidoExcluido 
		SELECT CD_FILIAL, CD_PROD 
		FROM EST_PROD_TRANSF_PEDIDO WHERE QT_PED < 0;

  end
IF @consulta%2=1 AND @CD_PROD IS NOT NULL  --DEBUG
  begin
	PRINT 'Registro de pedido apos ajustes no rateio - EST_PROD_TRANSF_PEDIDO  '  + CONVERT(VARCHAR, GETDATE(), 108);
	SELECT * FROM EST_PROD_TRANSF_PEDIDO; --DEBUG
	SELECT * FROM EST_PROD_TRANSF_CONSOLIDADO; --DEBUG 
  end
 ELSE 
	PRINT 'Realizados ajustes no rateio (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';
-----------------------------------------------------------------------------------------------

	--atualiza necessidade conforme rateio
	UPDATE 
		n 
	SET 
		QT_EST_RESSUP=ROUND(p.QT_PED,0), 
		FLAG_RATEIO=1, 
		PERC_RATEIO=p.PERC_RATEIO, 
		QTDE_DEPOS_SOMA=p.QTDE_DEPOS_SOMA, 
		QTDE_FILIAIS_SOMA=p.QTDE_FILIAIS_SOMA,                                                                                                                       
		MEDIAF_SOMA=p.MEDIAF_SOMA
	FROM 
		EST_PROD_TRANSF_NECESSIDADE n JOIN EST_PROD_TRANSF_PEDIDO p ON 
		p.CD_PROD=n.CD_PROD AND 
		p.CD_FILIAL=n.CD_FILIAL;
	--recalcula soma dos pedidos
	UPDATE s SET 
		QT_RESSUP_SOMA=(SELECT SUM(QT_EST_RESSUP) FROM EST_PROD_TRANSF_NECESSIDADE WHERE CD_PROD=s.CD_PROD),
		FLAG_RATEIO=1
	FROM 
		EST_PROD_TRANSF_CONSOLIDADO s
	WHERE 
		EXISTS (SELECT * FROM EST_PROD_TRANSF_NECESSIDADE WHERE CD_PROD=s.CD_PROD AND FLAG_RATEIO=1);
	
	DROP TABLE EST_PROD_TRANSF_PEDIDO;
--------------------------------------------------------------------------------------

IF @consulta/2%2=0 AND @CD_PROD IS NOT NULL  --DEBUG
  begin
	PRINT 'Registro de necessidade apos ajustes no rateio - EST_PROD_TRANSF_NECESSIDADE';
	SELECT * FROM EST_PROD_TRANSF_NECESSIDADE; --DEBUG
	PRINT 'Registro de somas (filiais e deposito) apos ajustes no rateio - EST_PROD_TRANSF_CONSOLIDADO';
	SELECT * FROM EST_PROD_TRANSF_CONSOLIDADO; --DEBUG
  end
 ELSE 
  begin
	PRINT 'Realizados ajustes no rateio (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';
	declare @prods varchar(100);
	set @prods=(SELECT convert(varchar(5), count(*)) + ' produtos para arredondamento. ' 
		FROM EST_PROD_TRANSF_CONSOLIDADO WHERE QT_RESSUP_SOMA <> QT_DEPOSITO AND FLAG_RATEIO=1);
	print isnull(@prods, 'Nenhum produto para arredondamento. '); 
	set @prods='';
	SELECT @prods=@prods+',' + CONVERT(VARCHAR(8), cd_prod) 
		FROM EST_PROD_TRANSF_CONSOLIDADO WHERE QT_RESSUP_SOMA <> QT_DEPOSITO AND FLAG_RATEIO=1;
	if len(@prods) > 0
		begin
			print 'Produtos para arredondamento: ' + right(@prods, len(@prods)-2) + '. ';
		end
	else
		begin
			print 'Nenhum produto para arredondamento.';
		end
  end
--===REALIZA AJUSTE NO RATEIO, DEVIDO A POSS?VEIS PROBLEMAS NO ARREDONDAMENTO PARA CADA FILIAL===
--enquanto houver produtos onde foi feito rateio com diferenca entre o que se tem no deposito e o que se quer pedir..
UPDATE 
EST_PROD_TRANSF_CONSOLIDADO
SET QT_DEPOSITO= ROUND(QT_DEPOSITO,0,1);
WHILE EXISTS   (SELECT * FROM EST_PROD_TRANSF_CONSOLIDADO s
				WHERE QT_RESSUP_SOMA <> QT_DEPOSITO AND FLAG_RATEIO=1)
  begin  
	/*SIGN(QT_DEPOSITO - QT_RESSUP_SOMA) ? o fator de ajuste (+1 se sobrou um produto no deposito, -1 se faltou).
	* (ROUND(QT_EST_RESSUP, 0) + QTDE_EST + b.FATOR_AJUSTE) * 30 / QTDE_MEDIAF ? a cobertura PROJETADA
	* a ?ltima subquery pega a filial que ficaria com a menor (TOP 1) cobertura com +1 produto (ajuste)
	* ou a maior cobertura com -1 produto (multiplicando com o fator a maior cobertura passa a ser o menor valor)
	* nessa filial ? que o pedido ? ajustado em mais ou menos 1 */
	IF @consulta/2%2=1 AND @CD_PROD IS NOT NULL  --DEBUG
	  begin
		
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Registro de necessidade durante arredondamento - EST_PROD_TRANSF_NECESSIDADE'
			,'INSERT'
			, 2364
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_NECESSIDADE'
			,'RESSUPRIMENTO');

		;WITH BASE AS (
				SELECT 
					CD_PROD, 
					FATOR_AJUSTE=SIGN(QT_DEPOSITO - QT_RESSUP_SOMA) 
				FROM 
					EST_PROD_TRANSF_CONSOLIDADO 
				WHERE 
					QT_DEPOSITO <> QT_RESSUP_SOMA AND FLAG_RATEIO=1)
		SELECT 
			CONVERT(DECIMAL(10,3), (SELECT 
											CASE WHEN n.QT_EST_RESSUP + n.QTDE_EST <> 0 OR FATOR_AJUSTE = 1 THEN--nao mostra os que ficariam negativos 
												(n.QT_EST_RESSUP + n.QTDE_EST + FATOR_AJUSTE) * 30/ CASE WHEN QTDE_MEDIAF=0 THEN 
																												.001 
																										ELSE QTDE_MEDIAF 
																									END 
											END
										FROM 
											BASE 
										WHERE CD_PROD=n.CD_PROD)) AS cobertura_projetada, 
			* 
		FROM 
			EST_PROD_TRANSF_NECESSIDADE n 
		ORDER BY 
			COBERTURA_PROJETADA DESC
		PRINT 'Registro de somas (filiais e deposito) durante arredondamento - EST_PROD_TRANSF_CONSOLIDADO';
		SELECT * FROM EST_PROD_TRANSF_CONSOLIDADO; --DEBUG
	  end;
	WITH BASE AS (SELECT 
						CD_PROD, 
						FATOR_AJUSTE=CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
											  QT_UNI_RESSUPRIMENTO *
												(case when QT_DEPOSITO < QT_RESSUP_SOMA then -1 else 1 end)
											ELSE SIGN(QT_DEPOSITO - QT_RESSUP_SOMA) END
					FROM 
						EST_PROD_TRANSF_CONSOLIDADO 
					WHERE QT_DEPOSITO <> QT_RESSUP_SOMA AND FLAG_RATEIO=1)
	UPDATE 
		p 
	SET 
		QT_EST_RESSUP = CASE WHEN QT_EST_RESSUP + b.FATOR_AJUSTE > ROUND(p.EMAX,0) 
								THEN   
									CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
											ROUND(QT_UNI_RESSUPRIMENTO * ROUND(p.EMAX - p.QTDE_EST,0),0)
										else
											 ROUND(p.EMAX - p.QTDE_EST,0)
										end
							ELSE 
								QT_EST_RESSUP + b.FATOR_AJUSTE  
							END,
		FLAG_AJUSTE_RATEIO=1
	FROM 
		EST_PROD_TRANSF_NECESSIDADE p 
		JOIN BASE b ON 
		p.CD_PROD=b.CD_PROD
	WHERE p.CD_FILIAL = (SELECT	 TOP 1 CD_FILIAL
						   FROM 
								EST_PROD_TRANSF_NECESSIDADE
						   WHERE 
								CD_PROD=b.CD_PROD
								--AND QTDE_MEDIAF >= 0
								--and QT_EST_RESSUP <> 0
						   ORDER BY 
								b.FATOR_AJUSTE * (QT_EST_RESSUP + QTDE_EST + b.FATOR_AJUSTE) * 30 / CASE WHEN  QTDE_MEDIAF = 0 THEN 
																										.001 ELSE QTDE_MEDIAF END, 
								b.FATOR_AJUSTE * (QT_EST_RESSUP + QTDE_EST + b.FATOR_AJUSTE));
	--ajusta tb a soma
	UPDATE 
		s 
	 SET 
		QT_RESSUP_SOMA = QT_RESSUP_SOMA + (CASE WHEN FLAG_RESSUPRIMENTO_CAIXA_FECHADA =1 THEN
											  QT_UNI_RESSUPRIMENTO *
												(case when QT_DEPOSITO < QT_RESSUP_SOMA then -1 else 1 end)
											ELSE SIGN(QT_DEPOSITO - QT_RESSUP_SOMA) END)
	 FROM 
		EST_PROD_TRANSF_CONSOLIDADO s
	 WHERE 
		QT_RESSUP_SOMA <> QT_DEPOSITO 
		AND EXISTS (SELECT * FROM EST_PROD_TRANSF_NECESSIDADE WHERE CD_PROD=s.CD_PROD AND FLAG_RATEIO=1);
		
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Realizou ajustes no ressuprimento '
		,'INSERT'
		, 2364
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_TRANSF_NECESSIDADE'
		,'RESSUPRIMENTO');

  END
DELETE FROM EST_PROD_TRANSF_NECESSIDADE WHERE QT_EST_RESSUP <= 0;
IF @consulta<>0 AND @CD_PROD IS NOT NULL  --DEBUG
  begin
	PRINT 'Registro de necessidade apos ajustes de arredondamento - EST_PROD_TRANSF_NECESSIDADE';
	SELECT * FROM EST_PROD_TRANSF_NECESSIDADE; --DEBUG
	PRINT 'Registro de somas (filiais e deposito) apos ajustes de arredondamento - EST_PROD_TRANSF_CONSOLIDADO';
	SELECT * FROM EST_PROD_TRANSF_CONSOLIDADO; --DEBUG
  end
 ELSE 
	PRINT 'Realizado arredondamento (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';
--fim 
END TRY ---------------------------------------------------------------------------------------------------------
BEGIN CATCH  --Registra erro na tabela de hist?rico de erros do banco Gestao
	SELECT	@mensagemErro = ERROR_MESSAGE(), 
			@severidadeErro = ERROR_SEVERITY(), 
			@estadoErro = ERROR_STATE();
    INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			@severidadeErro AS severidade,
			@estadoErro AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			@mensagemErro AS mensagem,
			GETDATE() AS dtErro; 
	RAISERROR (@mensagemErro, @severidadeErro, @estadoErro); 
	RETURN -1;
END CATCH; 
/*******************************************************************************************************/
/*******************************************************************************************************/
/*******************************************************************************************************/
--								Capacidade do CD
/*******************************************************************************************************/
	PRINT 'Ajusta ao limite capacidade CD (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')'; 
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Ajusta ao limite capacidade CD' 
		,'INSERT'
		, 2496
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_CAPACIDADE'
		,'RESSUPRIMENTO');
--	return;
	EXEC P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_CAPACIDADE @CD_EMP, @CD_DEPOSITO, @HOJE, @CONSULTA;
	PRINT 'Fim da rotina de limite capacidade CD ( (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')'; 
/*******************************************************************************************************/
--Aplicando desconto padrao no ressuprimento
-- Desconto por classificacao de cliente...
/*******************************************************************************************************/
	if @RealizaDescVendaGrpEcon=1
	begin
		 
		update n 
		set  PERC_DESC=d.PERC_DESC
		from
			EST_PROD_TRANSF_NECESSIDADE n
			JOIN PRC_FILIAL_RC_CLI C ON 
			N.CD_FILIAL  = C.CD_FILIAL 
			JOIN PRC_GRP_ECON_PRC_FILIAL E on 
			N.CD_FILIAL  = C.CD_FILIAL 
			and CD_GRP_ECON <> @CD_GRP_ECON_DEPOSITO
			CROSS APPLY ( SELECT PERC_DESC 
						FROM dbo.UFD_BUSCA_EST_PROD_TBL_DESC_PADRAO(@cd_emp, @CD_DEPOSITO,N.CD_PROD, 0, C.CD_CLI)
						) D

		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Aplicando desconto nas vendas entre grupos economicos'
		,'UPDATE'
		, 2527
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'UFD_BUSCA_EST_PROD_TBL_DESC_PADRAO'
		,'RESSUPRIMENTO')

	end
/*******************************************************************************************************/
BEGIN TRY  --------------------------------------------------------------------------------------------------
IF @CONSULTA=0
  begin
	BEGIN  TRANSACTION; 
	--Gerando ressuprimento de itens sem caixa fechada
	--==================REGISTRO DAS TRANSFER?NCIAS=====================
	--pega ultimo registro de transferencia do deposito
	DECLARE	@CD_TRANSF INT, @CD_TRANSF_INI INT,
			@STS_TRANSF TINYINT=0 ;
	SET @CD_TRANSF = ISNULL((SELECT MAX(CD_CTR) FROM EST_PROD_TRANSF WITH (TABLOCKX) 
							 WHERE CD_EMP=@CD_EMP AND CD_FILIAL=@CD_DEPOSITO),0);
	SET @CD_TRANSF_INI = @CD_TRANSF ;	
	SET @STS_TRANSF =0	--Debugs
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'RegistraNdo cabecalho ressuprimento nr.: (' + CONVERT(VARCHAR(12), @CD_TRANSF) + ')'
		,'INSERT'
		, 2553
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_TRANSF'
		,'RESSUPRIMENTO')

	--gera um novo registro de transferencia do deposito para cada filial e cada grupo de ressuprimento
	INSERT INTO EST_PROD_TRANSF (CD_EMP,  CD_FILIAL, CD_CTR, TP_TRANSF, 
									 CD_FIL_ORIG, CD_FIL_DEST, DT_TRANSF, DT_ENTR, STS_TRANSF, 
									 DT_CAD, CD_USU , HR_TRANSF,CD_AGD_RESSUP) 
		SELECT DISTINCT
			@CD_EMP AS CD_EMP,
			@CD_DEPOSITO AS CD_FILIAL,
			@CD_TRANSF + ORDEM AS CD_CTR,
			0 AS TP_TRANSF,
			@CD_DEPOSITO AS CD_FIL_ORIG,
			O.CD_FILIAL AS CD_FIL_DEST,
			DT_TRANSF=@HOJE,
			DT_ENTR=@HOJE,
			@STS_TRANSF  AS STS_TRANSF,
			DT_CAD=@HOJE,
			1 AS CD_USU,
			GETDATE(),
			@cd_agenda
		FROM 
			V_EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL_ORDEM o
			INNER JOIN V_PRC_FILIAL_DEPOSITO D ON 
			O.CD_EMP      = D.CD_EMP AND 
			O.CD_FILIAL   = D.CD_FILIAL  AND 
			D.CD_CTR_DEPO = @CD_CTR_DEPO 
		WHERE 
			O.CD_EMP=@CD_EMP   --s? para grupos de ressuprimento com produtos que necessitam ser ressupridos
			AND ISNULL(O.CD_CTR_DEPO,@CD_CTR_DEPO)=@CD_CTR_DEPO
			AND EXISTS (SELECT 
								*
						FROM 
							EST_PROD_TRANSF_NECESSIDADE f 
							INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
							f.CD_PROD=s.CD_PROD
						WHERE
							o.CD_FILIAL = f.cd_filial AND
							--o.CD_GRP_RES = f.CD_GRP_RES AND
							o.CD_GRP_PRT=f.CD_GRP_PRT 
							AND CASE WHEN @NAO_DIVIDE_RESSUP_CX_FECHADA =1 THEN 0 
								ELSE f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA END =0)
		ORDER BY CD_CTR;
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Registrado cabecalho sem caixa fechada '
		,'INSERT'
		, 2603
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_TRANSF'
		,'RESSUPRIMENTO')

	--gera um novo item de transfer?ncia para cada filial e produto com necessidade de ressuprimento
	
	DECLARE @CD_MOV_OP_TRANSF_FILIAIS INT;
	DECLARE @TP_MOV_TRANSF_FILIAIS INT;
	DECLARE @FLAG_COMPOR_ICMS_SAIDA_TRANSFERENCIA INT;
		
	select TOP 1 @FLAG_COMPOR_ICMS_SAIDA_TRANSFERENCIA = VALOR
	from PRC_FILIAL_CONFIG
	where cd_chave = 'FLAG_COMPOR_ICMS_SAIDA_TRANSFERENCIA'
	AND CD_FILIAL = @CD_DEPOSITO /*Filial Origem*/
	
	SELECT TOP 1 @CD_MOV_OP_TRANSF_FILIAIS = VALOR
	FROM PRC_FILIAL_CONFIG 
	WHERE CD_CHAVE  = 'CD_MOV_OP_TRANSF_FILIAIS' 
	AND CD_FILIAL  = @CD_DEPOSITO /*Filial Origem*/

	SELECT TOP 1 @TP_MOV_TRANSF_FILIAIS = TP_MOV
	FROM GLB_MOV_OP
	WHERE CD_MOV_OP = @CD_MOV_OP_TRANSF_FILIAIS
	
	DECLARE @cd_chave INT;
	DECLARE c_FilRessup CURSOR FAST_FORWARD
	FOR SELECT DISTINCT
				cd_filial
		FROM
				V_EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL_ORDEM
			WHERE ISNULL(CD_CTR_DEPO,@CD_CTR_DEPO)=@CD_CTR_DEPO;
	OPEN c_FilRessup;
	FETCH NEXT FROM c_FilRessup INTO @cd_chave;
	WHILE @@FETCH_STATUS = 0
		BEGIN 

			INSERT INTO EST_PROD_TRANSF_IT ( CD_EMP
												, CD_FILIAL
												, CD_CTR
												, CD_PROD
												, QT_SOL
												, QT_AT
												, VLR_CUSTO
												, QT_EST_RES
												, QT_MEDIAF
												, QT_EMAX
												, QT_ESEG
												, FLAG_RATEIO
												, QT_EST_DEPO_RES
												, PERC_DESC
												, QT_EST
												, QT_PEND_ENT
												, EMAX_RES
												, ESEG_RES
												, PERC_RATEIO
												, VLR_CUSTO_MD
												, QT_UNI_RESSUPRIMENTO
												, QT_NECESSIDADE
												, TP_PRECO
												, ALIQ_ICMS_ENTRADA
												, VLR_CUSTO_PROD_ORIG	, PARAM_ADD_AGENDA)
				SELECT
					@CD_EMP AS CD_EMP
					, @CD_DEPOSITO AS CD_FILIAL
					, @CD_TRANSF + o.ORDEM AS CD_CTR
					, f.CD_PROD
					, QT_SOL = CASE
									WHEN s.QT_DEPOSITO >= f.QT_EST_RESSUP THEN --Quantidade do deposito maior que o ressuprimento
								ISNULL(f.QT_EST_RESSUP, 0)
									ELSE --Quantidade do deposito menor que o ressuprimento
									ISNULL(s.QT_DEPOSITO, 0)
								END
					, 0 AS QT_AT
					, ROUND(ISNULL(f.VLR_PROD, 0) / CASE 
														WHEN ISNULL(TRIB.VLR_ICMS,0) > 0 
														THEN ((100.00 - TRIB.VLR_ICMS) / 100.00)
													ELSE 1 
													END, 2) AS VLR_PROD
					, ISNULL(f.QT_EST_RESSUP_INI, 0) AS QT_EST_RESSUP_INI
					, ISNULL(QTDE_MEDIAF, 0) AS QTDE_MEDIAF
					, ISNULL(EMAXCAD, 0) AS EMAXCAD
					, ISNULL(ESEGCAD, 0) AS ESEGCAD
					, ISNULL(f.FLAG_RATEIO, 0) AS FLAG_RATEIO
					, ISNULL(S.QT_DEPOSITO_INICIO, 0) AS QT_DEPOSITO_INICIO
					, ISNULL(f.PERC_DESC, 0) AS PERC_DESC
					, f.QT_EST_LJ
					, f.QT_PEND_ENT_LJ
					, f.EMAX
					, f.QMIN
					, F.PERC_RATEIO
					, f.VLR_CUSTO_MD
					, f.QT_UNI_RESSUPRIMENTO
					, ISNULL(f.QT_EST_RESSUP_INI, 0) AS NECESSIDADE_FILIAL
					, @TP_PRECO
					, f.ALIQ_ICMS_ENTRADA
					, f.VLR_CUSTO_PROD_ORIG
					, @ParamAddAgd
				FROM
					EST_PROD_TRANSF_NECESSIDADE f
					INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON f.CD_PROD = s.CD_PROD
					INNER JOIN V_EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL_ORDEM o ON f.CD_FILIAL = o.CD_FILIAL
																					AND --f.CD_GRP_RES=o.CD_GRP_RES AND
																					f.CD_GRP_PRT = o.CD_GRP_PRT
					INNER JOIN V_PRC_FILIAL_DEPOSITO D ON O.CD_EMP = D.CD_EMP
															AND O.CD_FILIAL = D.CD_FILIAL
															AND D.CD_CTR_DEPO = @CD_CTR_DEPO
					OUTER APPLY (SELECT T.VLR_ICMS
								 FROM dbo.UFD_EST_PROD_TRIB (1, @CD_DEPOSITO, @CD_MOV_OP_TRANSF_FILIAIS, @cd_chave, f.CD_PROD,
															 0, 0, 0, 1, ROUND(ISNULL(f.VLR_PROD, 0), 2), 0, 0, 0, 0, 0, 0) T
								 WHERE ISNULL(@TP_MOV_TRANSF_FILIAIS,0) = 10
								 AND ISNULL(@FLAG_COMPOR_ICMS_SAIDA_TRANSFERENCIA, 0) = 1
								 ) AS TRIB

				WHERE 
					o.CD_EMP = @CD_EMP   --s? para grupos de ressuprimento com produtos que necessitam ser ressupridos
					AND ISNULL(O.CD_CTR_DEPO,@CD_CTR_DEPO)=@CD_CTR_DEPO
					AND CASE WHEN @NAO_DIVIDE_RESSUP_CX_FECHADA = 1 THEN 0 
							ELSE f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
							END = 0
					and f.CD_FILIAL =@cd_chave
					AND EXISTS(SELECT * FROM
										EST_PROD_TRANSF_NECESSIDADE f
										INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON f.CD_PROD = s.CD_PROD
								WHERE o.CD_FILIAL = f.cd_filial
										AND --o.CD_GRP_RES = f.CD_GRP_RES AND
										o.CD_GRP_PRT = f.CD_GRP_PRT
										AND CASE
												WHEN @NAO_DIVIDE_RESSUP_CX_FECHADA = 1 THEN 0
												ELSE f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
											END = 0
							)
				ORDER BY O.ORDEM;
				
				
				/*Implementao da associao ao LOTE - FARMAGOI-48695*/
				
				
				
				
				
			FETCH NEXT FROM c_FilRessup INTO @cd_chave;
		END;
	CLOSE c_FilRessup; 
	DEALLOCATE c_FilRessup;

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Registrado itens sem caixa fechada '
		,'INSERT'
		, 2714
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_TRANSF_IT'
		,'RESSUPRIMENTO')
			 

--xxxxxxxxxxxxxxxxxxxxxxxxxFinal ressuprimento sem caixa fechada xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx 
--xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    IF @NAO_DIVIDE_RESSUP_CX_FECHADA=0
	BEGIN
	    --Gerando ressuprimento de itens caixa fechada
	    --==================REGISTRO DAS TRANSFERENCIAS=====================
	    --pega ultimo registro de transferencia do deposito
	    SET @CD_TRANSF = ISNULL((SELECT MAX(CD_CTR) FROM EST_PROD_TRANSF WITH (TABLOCKX) 
									WHERE CD_EMP=@CD_EMP AND CD_FILIAL=@CD_DEPOSITO),0);
	    --gera um novo registro de transferencia do deposito para cada filial e cada grupo de ressuprimento
	    INSERT INTO EST_PROD_TRANSF	(CD_EMP, CD_FILIAL, CD_CTR, TP_TRANSF, CD_FIL_ORIG, 
								    CD_FIL_DEST, DT_TRANSF, DT_ENTR, STS_TRANSF, DT_CAD, 
								    CD_USU,FLAG_CAIXA_FECHADA, HR_TRANSF,CD_AGD_RESSUP) 
	    SELECT DISTINCT
		    @CD_EMP AS CD_EMP,
		    @CD_DEPOSITO AS CD_FILIAL,
		    @CD_TRANSF + ORDEM AS CD_CTR,
		    0 AS TP_TRANSF,
		    @CD_DEPOSITO AS CD_FIL_ORIG,
		    O.CD_FILIAL AS CD_FIL_DEST,
		    DT_TRANSF=@HOJE,
		    DT_ENTR=@HOJE,
		    @STS_TRANSF  AS STS_TRANSF,
		    DT_CAD=@HOJE,
		    1 AS CD_USU,
		    1,
		    GETDATE(),
			@cd_agenda
	    FROM 
		    V_EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL_ORDEM o
		    INNER JOIN V_PRC_FILIAL_DEPOSITO D ON 
		    O.CD_EMP    = D.CD_EMP AND
		    O.CD_FILIAL = D.CD_FILIAL AND 
		    D.CD_CTR_DEPO = @CD_CTR_DEPO  
	    WHERE 
		    O.CD_EMP=@CD_EMP   --s? para grupos de ressuprimento com produtos que necessitam ser ressupridos
			AND ISNULL(O.CD_CTR_DEPO,@CD_CTR_DEPO)=@CD_CTR_DEPO
		    AND EXISTS (SELECT 
						    *
					    FROM 
						    EST_PROD_TRANSF_NECESSIDADE f	
						    INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
						    f.CD_PROD=s.CD_PROD
					    WHERE
						    o.CD_FILIAL  = f.cd_filial AND
						    --o.CD_GRP_RES = f.CD_GRP_RES AND
						    o.CD_GRP_PRT = f.CD_GRP_PRT AND
						    f.QT_UNI_RESSUPRIMENTO > 0
						    AND f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
						    AND (CASE WHEN s.QT_DEPOSITO >= f.QT_EST_RESSUP THEN 
										    f.QT_EST_RESSUP 
								    ELSE s.QT_DEPOSITO END) >= 1)
	    ORDER BY CD_CTR;
	    
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
			,'Registrado cabecalho caixa fechada'
			,'INSERT'
			, 2778
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF'
			,'RESSUPRIMENTO')
	    --gera um novo item de transfer?ncia para cada filial e produto com necessidade de ressuprimento
	    INSERT INTO EST_PROD_TRANSF_IT (CD_EMP, CD_FILIAL, CD_CTR, CD_PROD, 
											QT_SOL, QT_AT, VLR_CUSTO,QT_EST_RES,
											QT_MEDIAF,QT_EMAX,QT_ESEG,FLAG_RATEIO,QT_EST_DEPO_RES,
											PERC_DESC,QT_EST,QT_PEND_ENT,EMAX_RES,ESEG_RES,
											PERC_RATEIO,VLR_CUSTO_MD,QT_UNI_RESSUPRIMENTO,QT_NECESSIDADE, 
											TP_PRECO,ALIQ_ICMS_ENTRADA, VLR_CUSTO_PROD_ORIG,PARAM_ADD_AGENDA)
	    SELECT 
		    @CD_EMP AS CD_EMP,
		    @CD_DEPOSITO AS CD_FILIAL,
		    @CD_TRANSF + o.ORDEM AS CD_CTR,
		    f.CD_PROD,
		    QT_SOL = (CASE WHEN s.QT_DEPOSITO >= f.QT_EST_RESSUP THEN 
								    f.QT_EST_RESSUP ELSE s.QT_DEPOSITO END),
		    /*
			QT_AT  = (CASE WHEN s.QT_DEPOSITO >= f.QT_EST_RESSUP THEN 
							    f.QT_EST_RESSUP ELSE s.QT_DEPOSITO END),
			*/
			0 AS QT_AT,					
		    ROUND(ISNULL(f.VLR_PROD, 0) / CASE 
														WHEN ISNULL(TRIB.VLR_ICMS,0) > 0 
														THEN ((100.00 - TRIB.VLR_ICMS) / 100.00)
													ELSE 1 
													END, 2) AS VLR_PROD,
		    f.QT_EST_RESSUP_INI,
		    QTDE_MEDIAF,
		    EMAXCAD,
		    ESEGCAD,
		    f.FLAG_RATEIO,
		    ISNULL(QT_DEPOSITO_INICIO, 0) AS QT_DEPOSITO_INICIO,
		    ISNULL(f.PERC_DESC, 0) AS PERC_DESC,
		    F.QT_EST_LJ,
		    F.QT_PEND_ENT_LJ,
		    F.EMAX,
		    F.QMIN,
		    F.PERC_RATEIO,
		    F.VLR_CUSTO_MD,
		    f.QT_UNI_RESSUPRIMENTO,
		    ISNULL(f.QT_EST_RESSUP_INI,0) as NECESSIDADE_FILIAL,
			@TP_PRECO,
			f.ALIQ_ICMS_ENTRADA,
			f.VLR_CUSTO_PROD_ORIG,
			@ParamAddAgd
	    FROM 
		    EST_PROD_TRANSF_NECESSIDADE f 
		    INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
		    f.CD_PROD = s.CD_PROD
		    INNER JOIN V_EST_ARV_GRP_RESSUPRIMENTO_PRC_FILIAL_ORDEM o ON 
		    f.CD_FILIAL=o.CD_FILIAL AND 
		    --f.CD_GRP_RES=o.CD_GRP_RES AND
		    f.CD_GRP_PRT=o.CD_GRP_PRT
		    INNER JOIN V_PRC_FILIAL_DEPOSITO D ON 
		    O.CD_EMP      = D.CD_EMP AND 
		    O.CD_FILIAL   = D.CD_FILIAL  AND 
		    D.CD_CTR_DEPO = @CD_CTR_DEPO
			OUTER APPLY (SELECT T.VLR_ICMS
								 FROM dbo.UFD_EST_PROD_TRIB (1, @CD_DEPOSITO, @CD_MOV_OP_TRANSF_FILIAIS, @cd_chave, f.CD_PROD,
															 0, 0, 0, 1, ROUND(ISNULL(f.VLR_PROD, 0), 2), 0, 0, 0, 0, 0, 0) T
								 WHERE ISNULL(@TP_MOV_TRANSF_FILIAIS,0) = 10
								 AND ISNULL(@FLAG_COMPOR_ICMS_SAIDA_TRANSFERENCIA, 0) = 1
								 ) AS TRIB
	    WHERE 
		    o.CD_EMP=@CD_EMP   --s? para grupos de ressuprimento com produtos que necessitam ser ressupridos
			AND ISNULL(O.CD_CTR_DEPO,@CD_CTR_DEPO)=@CD_CTR_DEPO
		    AND f.QT_UNI_RESSUPRIMENTO > 0
		    AND f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
		    AND (CASE WHEN s.QT_DEPOSITO >= f.QT_EST_RESSUP THEN 
				    f.QT_EST_RESSUP ELSE s.QT_DEPOSITO END)>= 1
		    AND EXISTS (SELECT 
						    *
					    FROM 
						    EST_PROD_TRANSF_NECESSIDADE f INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
						    f.CD_PROD=s.CD_PROD
					    WHERE
						    o.CD_FILIAL = f.cd_filial AND
						    --o.CD_GRP_RES = f.CD_GRP_RES AND
						    o.CD_GRP_PRT=f.CD_GRP_PRT AND 
						    f.QT_UNI_RESSUPRIMENTO > 0
						    AND f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
						    AND (CASE WHEN s.QT_DEPOSITO >= f.QT_EST_RESSUP THEN 
									    f.QT_EST_RESSUP ELSE s.QT_DEPOSITO END)>= 1)
	    ORDER BY O.ORDEM;
	END
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Registrados itens  caixa fechada'
		,'INSERT'
		, 2860
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_TRANSF_IT'
		,'RESSUPRIMENTO')

--xxxxxxxxxxxxxxxxxxxxxxxxxFinal ressuprimento caixa fechada xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
--Quando tem arredondamento de caixa fechada por produto, executa o arredondamento da caixa de acordo com a tabela parametrizada: EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO
	 
	IF @FLAG_UTILIZA_ARREDONDAMENTO_RESSUP_DIRETO = 1
	BEGIN
		
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
			VALUES (GETDATE(),GETDATE()
			,'Utilizando arredondamento por parmetro - EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO'
			,'INSERT'
			, 2887
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO'
			,'RESSUPRIMENTO')


		INSERT INTO #ARREDONDA
		SELECT  
			B.CD_EMP
			,B.CD_FILIAL
			,B.CD_CTR
			,B.CD_PROD
			,B.QT_SOL
			,C.QTDE_ARREDOND 
			,CASE WHEN ((B.QT_SOL %  C.QTDE_ARREDOND) / C.QTDE_ARREDOND * 100 >= C.PERC_ARREDOND) THEN 
				CASE WHEN ROUND(B.QT_SOL / C.QTDE_ARREDOND, 0, 0) > 0
					 THEN ROUND(B.QT_SOL / C.QTDE_ARREDOND, 0, 0) * C.QTDE_ARREDOND
					 ELSE B.QT_SOL
					 END
			WHEN ((B.QT_SOL %  C.QTDE_ARREDOND) / C.QTDE_ARREDOND * 100 <= 100 - C.PERC_ARREDOND AND B.QT_SOL > C.QTDE_ARREDOND) THEN 
				CASE WHEN ROUND(B.QT_SOL/ C.QTDE_ARREDOND, 0, 1) > 0
					 THEN ROUND(B.QT_SOL/ C.QTDE_ARREDOND, 0, 1) * C.QTDE_ARREDOND
					 ELSE B.QT_SOL
					 END
			ELSE 
				B.QT_SOL 
			END AS QT_AJUSTADA,
			C.CD_USU,
			C.DT_CAD
		FROM 
			EST_PROD_TRANSF A
			INNER JOIN EST_PROD_TRANSF_IT B ON 
				A.CD_EMP = B.CD_EMP
				AND A.CD_CTR = B.CD_CTR
				AND A.CD_FILIAL = B.CD_FILIAL
			INNER JOIN EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO C ON 
				A.CD_EMP = C.CD_EMP
				AND B.CD_PROD = C.CD_PROD
				AND A.CD_FIL_DEST = C.CD_FILIAL
		WHERE 
			A.CD_EMP = @CD_EMP 
			AND A.DT_TRANSF = @HOJE 
			AND COALESCE(C.QTDE_ARREDOND, 1) > 1
		IF OBJECT_ID('TEMPDB..#ESTOQUE') IS NOT NULL 
		BEGIN
			DROP TABLE #ESTOQUE
		END
		SELECT
			CD_FILIAL
			,CD_PROD
			,SUM(QT_AJUSTADA) AS QTDE
		INTO 
			#ESTOQUE
		FROM 
			#ARREDONDA
		GROUP BY 
			CD_FILIAL, 
			CD_PROD
		IF OBJECT_ID('TEMPDB..#ALTERAR') IS NOT NULL 
		BEGIN
			DROP TABLE #ALTERAR
		END
		SELECT 
			B.CD_FILIAL,
			B.CD_PROD,
			A.QT_EST,
			B.QTDE
		INTO 
			#ALTERAR
		FROM 
			V_EST_PROD_CPL_ESTOQUE A
			INNER JOIN #ESTOQUE B ON 
				A.CD_PROD = B.CD_PROD
				AND A.CD_FILIAL = B.CD_FILIAL
		WHERE 
			A.QT_EST_PEND >= B.QTDE
		INSERT INTO
			EST_ARV_GRP_RESSUPRIMENTO_ARREDONDAMENTO_EST_PROD_TRANSF_IT (
				CD_EMP
				,CD_FILIAL
				,CD_CTR
				,CD_FIL_DEST
				,CD_PROD
				,QT_SOL
				,QTDE_ARREDOND
				,QT_SOL_ARREDOND
				,QT_EST
				,CD_USU
				,DT_REGISTRO)
		SELECT
			A.CD_EMP,
			A.CD_FILIAL,
			A.CD_CTR,
			A.CD_FIL_DEST,
			B.CD_PROD,
			B.QT_SOL,
			C.QTDE_ARREDOND,
			C.QT_AJUSTADA,
			ALT.QT_EST,
			C.CD_USU,
			C.DT_CAD
		FROM
			EST_PROD_TRANSF A
			INNER JOIN EST_PROD_TRANSF_IT B ON 
				A.CD_EMP = B.CD_EMP
				AND A.CD_FILIAL = B.CD_FILIAL
				AND A.CD_CTR = B.CD_CTR
			INNER JOIN #ARREDONDA C ON 
				B.CD_EMP = C.CD_EMP
				AND B.CD_FILIAL = C.CD_FILIAL
				AND B.CD_PROD = C.CD_PROD
				AND B.CD_CTR = C.CD_CTR
			INNER JOIN #ALTERAR ALT ON
				B.CD_FILIAL = ALT.CD_FILIAL
				AND B.CD_PROD = ALT.CD_PROD
		WHERE
			B.QT_SOL <> C.QT_AJUSTADA
		UPDATE 
			EST_PROD_TRANSF_IT 
		SET 
			QT_NECESSIDADE = C.QT_AJUSTADA, 
			QT_SOL = C.QT_AJUSTADA
		FROM 
			EST_PROD_TRANSF A
			INNER JOIN EST_PROD_TRANSF_IT B ON 
				A.CD_EMP = B.CD_EMP
				AND A.CD_FILIAL = B.CD_FILIAL
				AND A.CD_CTR = B.CD_CTR
			INNER JOIN #ARREDONDA C ON 
				B.CD_EMP = C.CD_EMP
				AND B.CD_FILIAL = C.CD_FILIAL
				AND B.CD_PROD = C.CD_PROD
				AND B.CD_CTR = C.CD_CTR
			INNER JOIN #ALTERAR ALT ON
				B.CD_FILIAL = ALT.CD_FILIAL
				AND B.CD_PROD = ALT.CD_PROD
		WHERE
			B.QT_SOL <> C.QT_AJUSTADA
		UPDATE 
			EST_PROD_TRANSF_IT 
		SET 
			QT_NECESSIDADE = QT_AJUSTADA, 
			QT_SOL = QT_AJUSTADA
		FROM 
			EST_PROD_TRANSF A
			INNER JOIN EST_PROD_TRANSF_IT B ON 
				A.CD_EMP = B.CD_EMP
				AND A.CD_FILIAL = B.CD_FILIAL
				AND A.CD_CTR = B.CD_CTR
			INNER JOIN #ARREDONDA C ON 
				A.CD_EMP = C.CD_EMP
				AND A.CD_FILIAL = C.CD_FILIAL
				AND B.CD_PROD = C.CD_PROD
				AND B.CD_CTR = C.CD_CTR
		WHERE 
			C.QT_AJUSTADA < B.QT_NECESSIDADE
	END
/***********************************************************************************************/
--Inserir as linhas 
/***********************************************************************************************/
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
	,'Inserir as linhas do ressuprimento'
	,'INSERT'
	, 3047
	,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
	,'EST_PROD_TRANSF_EST_PROD_SC'
	,'RESSUPRIMENTO')

	INSERT INTO EST_PROD_TRANSF_EST_PROD_SC (CD_EMP,CD_FILIAL,CD_CTR,CD_SC)
	SELECT DISTINCT
		T.CD_EMP,
		T.CD_FILIAL,
		T.CD_CTR,
		L.CD_ARV_MERC_LINHA
	FROM 
		EST_PROD_TRANSF T 
		INNER JOIN EST_PROD_TRANSF_IT I ON 
		T.CD_EMP= I.CD_EMP AND
		T.CD_FILIAL= I.CD_FILIAL AND
		T.CD_CTR= I.CD_CTR
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA L ON 
		I.CD_EMP		= L.CD_EMP AND
		I.CD_PROD		= L.CD_PROD
		LEFT JOIN EST_PROD_TRANSF_EST_PROD_SC S ON 
		T.CD_EMP	= S.CD_EMP AND
		T.CD_FILIAL	= S.CD_FILIAL AND
		T.CD_CTR	= S.CD_CTR 
	WHERE
		S.CD_EMP IS NULL
		AND T.DT_TRANSF =@HOJE
		AND I.CD_EMP=@CD_EMP
		AND T.CD_FILIAL =@CD_DEPOSITO;
/***********************************************************************************************/
-- Ajuste final no ressuprimento
/***********************************************************************************************/
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
	VALUES (GETDATE(),GETDATE()
		,'Acerto das quantidades de ressuprimento final'
		,'INSERT'
		, 3082
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_AJUSTE'
		,'RESSUPRIMENTO')

	EXEC P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_AJUSTE  @CD_EMP, @CD_CTR_DEPO,@HOJE , @CD_FILIAL;
	

/***********************************************************************************************/
-- Atualiza as quantidade atendidas - POOL_RESSUPRIMENTO 
/***********************************************************************************************/
	if @POOL_RESSUPRIMENTO= 1
	begin
		TRUNCATE TABLE EST_PROD_TRANSF_SOMA_POOL;
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Atualiza as quantidade atendidas - POOL_RESSUPRIMENTO ' 
		,'INSERT'
		, 3100
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_TRANSF_SOMA_POOL'
		,'RESSUPRIMENTO')

		INSERT INTO EST_PROD_TRANSF_SOMA_POOL(CD_EMP,CD_FILIAL,CD_PROD,SOMA_QT_SOL)
		SELECT 
			T.CD_EMP,
			T.CD_FIL_DEST,
			I.CD_PROD,
			SUM(I.QT_SOL)
		from 
			est_prod_transf t
			join est_prod_transf_it i on 
			t.cd_emp	= i.cd_emp and
			t.cd_filial = i.cd_filial and
			t.cd_ctr	= i.cd_ctr
		where
			t.cd_emp=1
			and t.CD_CTR > @CD_TRANSF_INI
			AND T.CD_FILIAL =@CD_DEPOSITO
			AND T.STS_TRANSF=@STS_TRANSF
		GROUP BY 
			T.CD_EMP,
			T.CD_FIL_DEST,
			I.CD_PROD
		UPDATE P
		SET
			QT_AT= QT_AT+SOMA_QT_SOL,
			QT_PEND = QT_PEND+ SOMA_QT_SOL
		FROM
			EST_PROD_TRANSF_GERAL a
			join EST_PROD_TRANSF_GERAL_CPL p on 
			a.cd_ctr = p.cd_Ctr
			INNER JOIN EST_PROD_TRANSF_SOMA_POOL  Y ON 
			a.CD_EMP	= Y.CD_EMP  AND 
			a.CD_FIL_DEST 	= Y.CD_FILIAL AND   
			p.CD_PROD	= Y.CD_PROD  
		WHERE 
			p.CD_EMP = @CD_EMP   
			AND A.DT_TRANSF= @HOJE
			AND A.STS_TRANSF=0
	end
/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
	--Atualizando parametro especial com o numero de frequencia em dias de ressuprimento
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Atualiza parametro especial com o numero de frequencia em dias de ressuprimento' 
		,'UPDATE'
		, 3173
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_ARV_MD_F_GRP_PARAM_ESPECIAIS'
		,'RESSUPRIMENTO')

	UPDATE 
	   pesp
	SET 
		pesp.FDIAS_ULT_ATU=@HOJE
	FROM         
		EST_ARV_MD_F_GRP_PARAM_ESPECIAIS pesp	
		INNER JOIN EST_PROD_TRANSF_MEDIAF_PARAMS p ON
		pesp.CD_EMP		  = p.CD_EMP AND 
		pesp.CD_GRP_PARAM = p.CD_GRP_PARAM
	WHERE
		pesp.CD_EMP = @CD_EMP 
		AND p.FDIAS > 0	
		AND p.PARAM_ESPECIAL = 1;
	--Deletando os parametros especiais com nao possui numero de dias de ressuprimento
	DELETE
	   pesp
	FROM         
		EST_ARV_MD_F_GRP_PARAM_ESPECIAIS pesp	
		INNER JOIN EST_PROD_TRANSF_MEDIAF_PARAMS p ON
		pesp.CD_EMP		  = p.CD_EMP AND 
		pesp.CD_GRP_PARAM = p.CD_GRP_PARAM
	WHERE
		pesp.CD_EMP = @CD_EMP 
		AND	p.FDIAS = 0
		AND p.PARAM_ESPECIAL = 1;
	
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Removidos parametros especiais'
		,'DELETE'
		, 3232
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_ARV_MD_F_GRP_PARAM_ESPECIAIS'
		,'RESSUPRIMENTO')

	if @QT_DIVIDE_RESSUP > 0 and @POOL_RESSUPRIMENTO =0
	BEGIN
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Executa rotina dive_ressup'
		,'EXECUTE'
		, 3243
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_DIVIDE_RESSUP'
		,'RESSUPRIMENTO')
			EXEC P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_DIVIDE_RESSUP @CD_EMP, @QT_DIVIDE_RESSUP
		 
	END
	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Divisao ressuprimento prateleiras robo'
		,'EXECUTE'
		, 3254
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_DIVIDE_ROBO'
		,'RESSUPRIMENTO') 

		EXEC P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL_DIVIDE_ROBO

	COMMIT TRANSACTION;----------------------------------------------------------------------------------------
	PRINT 'Registrado ressuprimento (' + CONVERT(VARCHAR(12), GETDATE(), 114) + ')';
  end
 ELSE IF @CD_PROD IS NULL
  begin
	IF @CONSULTA=1 
	begin
		PRINT 'Registro de necessidade ao final - EST_PROD_TRANSF_NECESSIDADE';
		SELECT 
			CD_PROD,
			QT_EST_RESSUP,
			QT_UNI_RESSUPRIMENTO,
			f.QT_EST_RESSUP,
			f.QT_EST_RESSUP AS QT_INT,
			f.QT_EST_RESSUP,
			f.QT_EST_RESSUP 
		FROM 
			EST_PROD_TRANSF_NECESSIDADE f
		WHERE 
			QT_UNI_RESSUPRIMENTO > 0	
			AND f.QT_EST_RESSUP > 1
			AND f.FLAG_RESSUPRIMENTO_CAIXA_FECHADA=1
		ORDER BY CD_PROD, CD_FILIAL; --DEBUG
		PRINT 'Registro de somas (filiais e deposito) ao final - EST_PROD_TRANSF_CONSOLIDADO';
		SELECT * FROM EST_PROD_TRANSF_CONSOLIDADO ORDER BY CD_PROD; --DEBUG
	end  
  end
/************************************************************************************************************/	
   IF @RegistraFaltas > 0 
	BEGIN
		--Gravando faltas
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
		,'Registro de faltas' 
		,'INSERT'
		, 3224
		,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
		,'EST_PROD_TRANSF_FALTAS'
		,'RESSUPRIMENTO');

		INSERT INTO EST_PROD_TRANSF_FALTAS (CD_EMP,CD_FILIAL,CD_PROD,CD_FILIAL_FALTA,DT_CAD,QT_PEDIDO,QT_FALTA,VLR_PROD,
												QT_EST_DEPO_RES,QT_FACEAMENTO,QT_FINANCIAMENTO,QT_MEDIAF,QT_LIMITADOR,
												QT_EST_FILIAL,QT_PEND_ENT,QT_EMAX,QT_ESEG,CD_AGENDA)
		SELECT 
			@CD_EMP,
			@CD_DEPOSITO,
			n.CD_PROD,
			n.CD_FILIAL,
			@HOJE,
			isnull(QT_RESSUP,0)  QT_EST_RESSUP,	 
			n.QT_EST_RESSUP_INI - isnull(QT_RESSUP,0) QT_FALTA,
			n.VLR_PROD	VLR_PROD,
			n.QT_EST_DEPO_RES,
			n.QT_FACEAMENTO,
			n.QT_FINANCIAMENTO,
			n.QTDE_MEDIAF QT_MEDIAF,
			n.QT_LIMITADOR,
			n.QT_EST_LJ QT_EST_FILIAL,
			n.QT_PEND_ENT_LJ QT_PEND_ENT,
			n.EMAXCAD QT_EMAX,
			n.ESEGCAD QT_ESEG ,
			@CD_AGENDA
		FROM 
			EST_PROD_TRANSF_NECESSIDADE n 
			left join (SELECT  F.CD_FILIAL, F.CD_PROD , (CASE WHEN s.QT_DEPOSITO >= f.QT_EST_RESSUP THEN 
								    f.QT_EST_RESSUP ELSE s.QT_DEPOSITO END) QT_RESSUP  FROM 
									EST_PROD_TRANSF_NECESSIDADE f 
									INNER JOIN EST_PROD_TRANSF_CONSOLIDADO s ON 
									f.CD_PROD = s.CD_PROD) res on 
			n.CD_FILIAL = RES.CD_FILIAL and
			n.CD_PROD = RES.CD_PROD  
			LEFT JOIN EST_PROD_TRANSF_FALTAS W ON 
			@CD_EMP 		  = w.CD_EMP	AND 
			@CD_DEPOSITO	  = w.CD_FILIAL AND
			n.CD_PROD 		  = w.CD_PROD	AND
			n.CD_FILIAL		  = w.CD_FILIAL_FALTA AND
			@HOJE			  = w.DT_CAD   
		WHERE
			w.CD_EMP IS NULL
			and NOT EXISTS (SELECT E.CD_EMP -- Remove da falta itens que tiveram arredondamento.
							FROM #ARREDONDA E 
									WHERE	E.CD_EMP	= 1
										AND	E.CD_FILIAL = N.CD_FILIAL
										AND E.CD_PROD	= N.CD_PROD);
		UPDATE F
		SET
			 F.CD_GRP_RES = P.CD_GRP_RES
			,F.CD_GRP_PARAM = P.CD_GRP_PARAM
			,F.EMAX = P.EMAX
			,F.ESEG = P.ESEG
			,F.PARAM_ESPECIAL = P.PARAM_ESPECIAL
			,F.FDIAS = P.FDIAS
			,F.CD_SIGLA = P.CD_SIGLA
			,F.QT_UNI_RESSUPRIMENTO = P.QT_UNI_RESSUPRIMENTO
			,F.FLAG_RESSUPRIMENTO_CAIXA_FECHADA = P.FLAG_RESSUPRIMENTO_CAIXA_FECHADA
			,F.ConsideraEseg = P.ConsideraEseg
			,F.TpGrupoParam = P.TpGrupoParam
		FROM
			EST_PROD_TRANSF_FALTAS F
			JOIN EST_PROD_TRANSF_MEDIAF_PARAMS P ON
			F.CD_EMP =P.CD_EMP AND
			F.CD_PROD =P.CD_PROD AND
			F.CD_FILIAL_FALTA =P.CD_FILIAL  
		WHERE 
				F.DT_CAD = @HOJE 
			AND F.CD_FILIAL =@CD_DEPOSITO
			AND F.CD_EMP=@CD_EMP;
		UPDATE FT
		SET
			QT_FALTA = (FT.QT_PEDIDO - ISNULL(RS.QT_PEDIDO,0))
		from 
			EST_PROD_TRANSF_FALTAS FT
			LEFT JOIN (SELECT
						T.CD_EMP,
						T.CD_FILIAL,
						I.CD_PROD,
						T.CD_FIL_DEST CD_FILIAL_FALTA,
						T.DT_CAD,
						SUM(I.QT_SOL) QT_PEDIDO
					FROM	
						EST_PROD_TRANSF T
						JOIN EST_PROD_TRANSF_IT I ON 
						T.CD_EMP = I.CD_EMP AND
						T.CD_FILIAL = I.CD_FILIAL AND
						T.CD_CTR = I.CD_CTR
					WHERE
						DT_CAD=@HOJE						
						AND T.CD_EMP = @CD_EMP	
						AND T.CD_FILIAL = @CD_DEPOSITO						
					GROUP BY 
						T.CD_EMP,
						T.CD_FILIAL,
						I.CD_PROD,
						T.CD_FIL_DEST,
						T.DT_CAD ) RS ON 
			FT.CD_EMP	 = RS.CD_EMP AND 
			FT.CD_FILIAL = RS.CD_FILIAL AND 
			FT.CD_PROD	 = RS.CD_PROD AND 
			FT.DT_CAD	 = RS.DT_CAD AND 
			FT.CD_FILIAL_FALTA = RS.CD_FILIAL_FALTA 
		WHERE 
			FT.DT_CAD	 = @HOJE
			AND FT.CD_EMP = @CD_EMP
			AND FT.CD_FILIAL = @CD_DEPOSITO;
		DELETE FROM EST_PROD_TRANSF_FALTAS 
		WHERE 
			DT_CAD	 = @HOJE
			AND CD_EMP = @CD_EMP
			AND CD_FILIAL = @CD_DEPOSITO
				AND QT_FALTA < 1;
		
		INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Registradas faltas ressuprimento '
			,'INSERT'
			, 3344
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'EST_PROD_TRANSF_FALTAS'
			,'RESSUPRIMENTO');
	END

	EXEC P_GRAVA_LOTE_TRANSFERENCIA_RESSUPRIMENTO; /*FARMAGOI-48695*/

	INSERT INTO GLB_EXEC_LOG_ROTINAS (DT_LOG,DT_HR_LOG,MSG_LOG,OPERADOR,LINHA,ROTINA,ROTINA_AUX,PROCESSO)	
		VALUES (GETDATE(),GETDATE()
			,'Processada rotina de gravamento dos lotes'
			,'INSERT'
			, 3499
			,'P_GERA_RESSUPRIMENTO_DEPOSITO_FILIAL'
			,'P_GRAVA_LOTE_TRANSFERENCIA_RESSUPRIMENTO'
			,'RESSUPRIMENTO');

END TRY ---------------------------------------------------------------------------------------------------
BEGIN CATCH  --Registra erro na tabela de hist?rico de erros do banco Gestao
	IF @@NESTLEVEL > 0  ROLLBACK TRANSACTION;----------------------------------------------------------------------------------
	SELECT	@mensagemErro = ERROR_MESSAGE(), 
			@severidadeErro = ERROR_SEVERITY(), 
			@estadoErro = ERROR_STATE();
    INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
	SELECT
		ERROR_NUMBER() AS numero,
		@severidadeErro AS severidade,
		@estadoErro AS estado,
		ERROR_PROCEDURE() AS rotina,
		ERROR_LINE() AS linha,
		@mensagemErro AS mensagem,
		GETDATE() AS dtErro;
	RAISERROR (@mensagemErro, @severidadeErro, @estadoErro);
	RETURN -2;	
END CATCH
RETURN
--================================ FIM DA ROTINA NORMAL ========================================
SemNecessidade:   
PRINT 'Nao ha necessidade de ressuprimento. Veja estoques:'
SELECT     
	mdf.CD_FILIAL, 
	QT_EST = pend.QT_EST_PEND,
	ESEG = CONVERT(INT, dbo.UFD_EST_AJUSTA_ESEG(CASE WHEN ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)=0 THEN
													MDF.QTDE_FACEAMENTO 
												ELSE
													ROUND(MDF.QTDE_FACEAMENTO  * (ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)/100.00),0)
												END, 
												mdf.VALID_QTDE_FACEAMENTO, mdf.QTDE_FINANCIADO, 
								   CASE WHEN mdf.QTDE_MEDIAF > 0 THEN ROUND(mdf.QTDE_MEDIAF/30 * arvmerc.ESEG, 2)
										ELSE ROUND(mdp.QTDE_MEDIAP / 30 * arvmerc.ESEG, 2) END)),
	SOBRA = pend.QT_EST_PEND -
		CONVERT(INT, dbo.UFD_EST_AJUSTA_ESEG(CASE WHEN ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)=0 THEN
													MDF.QTDE_FACEAMENTO 
												ELSE
													ROUND(MDF.QTDE_FACEAMENTO  * (ISNULL(MDF.PERC_ESEG_FACEAMENTO,0)/100.00),0)
												END,
											 mdf.VALID_QTDE_FACEAMENTO, 
											 mdf.QTDE_FINANCIADO, 
											 CASE WHEN mdf.QTDE_MEDIAF > 0 THEN 
												ROUND(mdf.QTDE_MEDIAF/30 * arvmerc.ESEG, 2)
											 ELSE 
												ROUND(mdp.QTDE_MEDIAP / 30 * arvmerc.ESEG, 2) 
											 END))
FROM         
	EST_PROD_CPL_MEDIAF mdf 
	INNER JOIN EST_PROD_TRANSF_MEDIAF_PARAMS arvmerc ON 
	mdf.CD_EMP		= arvmerc.CD_EMP AND 
	mdf.CD_FILIAL	= arvmerc.CD_FILIAL AND 
	mdf.CD_PROD		= arvmerc.CD_PROD 
	INNER JOIN V_EST_PROD_CPL_ESTOQUE pend ON  
	mdf.CD_EMP	  = pend.CD_EMP AND 
	mdf.CD_FILIAL = pend.CD_FILIAL AND 
	mdf.CD_PROD	  = pend.CD_PROD 
	--Filiais do mesmo deposito
	INNER JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL lj ON
	mdf.CD_EMP		= lj.CD_EMP AND
	mdf.CD_FILIAL	= lj.CD_FILIAL
	AND lj.CD_CTR_DEPO =@CD_CTR_DEPO	
	LEFT OUTER JOIN EST_PROD_CPL_MEDIAP mdp ON --Media prevista para produtos menores de 90 dias de nascimento na filial
	mdf.CD_EMP    = mdp.CD_EMP AND 
	mdf.CD_FILIAL = mdp.CD_FILIAL AND 
	mdf.CD_PROD   = mdp.CD_PROD
ORDER BY 
	SOBRA DESC;
RETURN -1;
----------------------------------
SemRateio:
DECLARE @QT_DEPOSITO INT;
SET @QT_DEPOSITO = (SELECT TOP 1 
						(QT_EST + QT_EST_EM_TERC) - QT_PEND_SAI
					FROM 
						V_EST_PROD_CPL_ESTOQUE
					WHERE 
						CD_EMP=@CD_EMP 
						AND CD_FILIAL=@CD_DEPOSITO 
						AND CD_PROD  =@CD_PROD)
PRINT 'EST_PROD_TRANSF_CONSOLIDADO nao preenchido pois o estoque disponivel ? ' + convert(varchar(10), @QT_DEPOSITO) + ' Deposito : ' + convert(varchar(10), @CD_DEPOSITO)
RETURN -2

GO

